/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.iterator;

import be.bagofwords.iterator.CloseableIterator;
import be.bagofwords.iterator.DataIterable;
import be.bagofwords.iterator.InterleavedIteratorOfIterators;
import be.bagofwords.iterator.SequentialIteratorOfIterators;
import be.bagofwords.iterator.SimpleIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class IterableUtils {
    public static <T> DataIterable<T> createIterable(DataIterable<? extends T> ... iterables) {
        return IterableUtils.createIterable(CombineMethod.SEQUENTIAL, iterables);
    }

    public static <T> DataIterable<T> createIterable(CombineMethod combineMethod, DataIterable<? extends T> ... iterables) {
        return IterableUtils.createIterable(combineMethod, Arrays.asList(iterables));
    }

    public static <T> DataIterable<T> createIterable(List<DataIterable<? extends T>> iterables) {
        return IterableUtils.createIterable(CombineMethod.SEQUENTIAL, iterables);
    }

    public static <T> DataIterable<T> createIterable(final Collection<T> collection) {
        return new DataIterable<T>(){

            @Override
            public CloseableIterator<T> iterator() {
                return IterableUtils.iterator(collection.iterator());
            }

            @Override
            public long apprSize() {
                return collection.size();
            }
        };
    }

    public static <T> DataIterable<T> createIterable(final CombineMethod combineMethod, final List<DataIterable<? extends T>> iterables) {
        return new DataIterable<T>(){

            @Override
            public CloseableIterator<T> iterator() {
                ArrayList iterators = new ArrayList();
                for (DataIterable iterable : iterables) {
                    iterators.add(iterable.iterator());
                }
                if (combineMethod == CombineMethod.SEQUENTIAL) {
                    return new SequentialIteratorOfIterators(iterators);
                }
                return new InterleavedIteratorOfIterators(iterators);
            }

            @Override
            public long apprSize() {
                long result = 0L;
                for (DataIterable iterable : iterables) {
                    result += iterable.apprSize();
                }
                return result;
            }
        };
    }

    public static <T> CloseableIterator<T> iterator(SimpleIterator<T> simpleIt) {
        return IterableUtils.iterator(simpleIt, null);
    }

    public static <T> CloseableIterator<T> iterator(final SimpleIterator<T> simpleIt, final T lastValue) {
        return new CloseableIterator<T>(){
            private T nextValue;
            {
                this.findNext();
            }

            private void findNext() {
                try {
                    this.nextValue = simpleIt.next();
                    if (this.nextValue == null) {
                        if (lastValue == null) {
                            this.close();
                        }
                    } else if (lastValue != null && this.nextValue.equals(lastValue)) {
                        this.close();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read next value ", e);
                }
            }

            @Override
            public boolean hasNext() {
                if (lastValue == null) {
                    return this.nextValue != null;
                }
                return !lastValue.equals(this.nextValue);
            }

            @Override
            public synchronized T next() {
                Object result = this.nextValue;
                this.findNext();
                return result;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Not implemented");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeInt() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        simpleIt.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to close iterator", e);
                    }
                }
            }
        };
    }

    public static <T> CloseableIterator<T> iterator(final Iterator<T> iterator) {
        return new CloseableIterator<T>(){

            @Override
            public void closeInt() {
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    public static <T> CloseableIterator<T> maxSizeIterator(final long maxIterations, final CloseableIterator<T> iterator) {
        return new CloseableIterator<T>(){
            private long numDone = 0L;

            @Override
            protected void closeInt() {
                iterator.close();
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext() && this.numDone < maxIterations;
            }

            @Override
            public T next() {
                ++this.numDone;
                return iterator.next();
            }
        };
    }

    public static <T> DataIterable<T> maxSizeIterable(final long maxIterations, final DataIterable<T> iterable) {
        if (maxIterations <= 0L) {
            throw new RuntimeException("Incorrect number of iterations " + maxIterations);
        }
        return new DataIterable<T>(){

            @Override
            public CloseableIterator<T> iterator() {
                return IterableUtils.maxSizeIterator(maxIterations, iterable.iterator());
            }

            @Override
            public long apprSize() {
                return Math.min(maxIterations, iterable.apprSize());
            }
        };
    }

    public static enum CombineMethod {
        SEQUENTIAL,
        INTERLEAVED;

    }
}

