/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.iterator;

import be.bagofwords.iterator.CloseableIterator;
import java.util.List;

public class InterleavedIteratorOfIterators<U>
extends CloseableIterator<U> {
    private final List<CloseableIterator<? extends U>> iterators;
    private int currPos;
    private U next;

    public InterleavedIteratorOfIterators(List<CloseableIterator<? extends U>> iterators) {
        this.iterators = iterators;
        this.currPos = 0;
        this.next = this.findNext();
    }

    private U findNext() {
        U result = null;
        for (int i = 0; i < this.iterators.size(); ++i) {
            if (this.iterators.get(this.currPos).hasNext()) {
                result = (U)this.iterators.get(this.currPos).next();
                break;
            }
            this.currPos = (this.currPos + 1) % this.iterators.size();
        }
        this.currPos = (this.currPos + 1) % this.iterators.size();
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public U next() {
        U result = this.next;
        this.next = this.findNext();
        return result;
    }

    @Override
    public void closeInt() {
        for (CloseableIterator<U> iterator : this.iterators) {
            iterator.close();
        }
    }
}

