/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.iterator;

import be.bagofwords.ui.UI;
import java.io.Closeable;
import java.util.Iterator;

public abstract class CloseableIterator<T>
implements Iterator<T>,
Closeable {
    private boolean wasClosed = false;
    private final String creatingMethod;

    public CloseableIterator() {
        StackTraceElement callingMethod = Thread.currentThread().getStackTrace()[2];
        this.creatingMethod = callingMethod.getFileName() + ":" + callingMethod.getLineNumber();
    }

    @Override
    public void close() {
        if (!this.wasClosed) {
            this.closeInt();
            this.wasClosed = true;
        }
    }

    public boolean wasClosed() {
        return this.wasClosed;
    }

    protected abstract void closeInt();

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.wasClosed) {
            UI.writeError("CloseableIterator was not closed! Was created in " + this.creatingMethod);
            this.close();
        }
    }
}

