/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.counts;

public class WindowOfCounts {
    private final long windowSize;
    private long countsInPreviousWindow;
    private long countsInCurrWindow;
    private long totalCounts;
    private long startOfCurrWindow;
    private long startOfPrevWindow;

    public WindowOfCounts(long windowSize) {
        this.windowSize = windowSize;
        this.startOfCurrWindow = System.currentTimeMillis();
        this.startOfPrevWindow = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCount() {
        if (System.currentTimeMillis() - this.startOfCurrWindow > this.windowSize) {
            WindowOfCounts windowOfCounts = this;
            synchronized (windowOfCounts) {
                if (System.currentTimeMillis() - this.startOfCurrWindow > this.windowSize) {
                    this.countsInPreviousWindow = this.countsInCurrWindow;
                    this.countsInCurrWindow = 0L;
                    this.startOfPrevWindow = this.startOfCurrWindow;
                    this.startOfCurrWindow = System.currentTimeMillis();
                }
            }
        }
        ++this.countsInCurrWindow;
        ++this.totalCounts;
    }

    public double getMsPerCount() {
        double totalCounts = this.countsInPreviousWindow + this.countsInCurrWindow;
        if (totalCounts == 0.0) {
            return Double.MAX_VALUE;
        }
        return (double)(System.currentTimeMillis() - this.startOfPrevWindow) / totalCounts;
    }

    public long getNeededTime(long countsToDo) {
        double msPerCount = this.getMsPerCount();
        if (msPerCount == Double.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return Math.round((double)countsToDo * msPerCount);
    }

    public long getTotalCounts() {
        return this.totalCounts;
    }

    public long getCounts() {
        return this.countsInPreviousWindow + this.countsInCurrWindow;
    }

    public void clearCounts() {
        this.startOfCurrWindow = System.currentTimeMillis();
        this.startOfPrevWindow = System.currentTimeMillis();
        this.totalCounts = 0L;
        this.countsInCurrWindow = 0L;
        this.countsInPreviousWindow = 0L;
    }
}

