/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.counts;

import be.bagofwords.ui.UI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DoubleCounter<T> {
    private final HashMap<T, Double> counts = new HashMap();

    public void inc(T s) {
        this.inc(s, 1.0);
    }

    public void inc(T s, double value) {
        if (this.counts.containsKey(s)) {
            this.counts.put(s, this.counts.get(s) + value);
        } else {
            this.counts.put(s, value);
        }
    }

    public void print() {
        ArrayList<Map.Entry<T, Double>> orderedCounts = new ArrayList<Map.Entry<T, Double>>(this.counts.entrySet());
        Collections.sort(orderedCounts, new Comparator<Map.Entry<T, Double>>(){

            @Override
            public int compare(Map.Entry<T, Double> o1, Map.Entry<T, Double> o2) {
                return -o1.getValue().compareTo(o2.getValue());
            }
        });
        for (Map.Entry entry : orderedCounts) {
            UI.write(entry.getKey() + " (" + entry.getValue() + ")");
        }
    }

    public String[] keySet() {
        Set<String> var = this.counts.keySet();
        return var.toArray(new String[var.size()]);
    }

    public List<T> sortedKeys() {
        Set<T> keys = this.counts.keySet();
        ArrayList<T> result = new ArrayList<T>(keys);
        Collections.sort(result, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return -Double.compare(DoubleCounter.this.get(o1), DoubleCounter.this.get(o2));
            }
        });
        return result;
    }

    public double get(T s) {
        Double count = this.counts.get(s);
        if (count == null) {
            return 0.0;
        }
        return count;
    }

    public double getTotal() {
        int total = 0;
        for (Double val : this.counts.values()) {
            total = (int)((double)total + val);
        }
        return total;
    }

    public double getMax() {
        double max = 0.0;
        for (Double val : this.counts.values()) {
            max = Math.max(max, val);
        }
        return max;
    }

    public int size() {
        return this.counts.size();
    }

    public void set(T s, double value) {
        this.counts.put(s, value);
    }

    public void addAll(DoubleCounter<T> other) {
        for (Map.Entry<T, Double> entry : super.entrySet()) {
            this.inc(entry.getKey(), entry.getValue());
        }
    }

    private Set<Map.Entry<T, Double>> entrySet() {
        return this.counts.entrySet();
    }
}

