/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.counts;

import be.bagofwords.ui.UI;
import be.bagofwords.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.codehaus.jackson.annotate.JsonIgnore;

public class Counter<T> {
    private final Map<T, Long> counts = new HashMap<T, Long>();
    private long cachedTotal = -1L;
    private Semaphore lock = new Semaphore(1000);

    public void inc(T s) {
        this.inc(s, 1L);
    }

    public synchronized void inc(T s, long count) {
        if (this.counts.containsKey(s)) {
            this.lock.acquireUninterruptibly(1);
            this.counts.put(s, this.counts.get(s) + count);
            this.lock.release();
        } else {
            this.lock.acquireUninterruptibly(1000);
            this.counts.put(s, count);
            this.lock.release(1000);
        }
        this.cachedTotal = -1L;
    }

    public void print() {
        ArrayList<Map.Entry<T, Long>> orderedCounts = new ArrayList<Map.Entry<T, Long>>(this.counts.entrySet());
        Collections.sort(orderedCounts, new Comparator<Map.Entry<T, Long>>(){

            @Override
            public int compare(Map.Entry<T, Long> o1, Map.Entry<T, Long> o2) {
                return -o1.getValue().compareTo(o2.getValue());
            }
        });
        for (Map.Entry entry : orderedCounts) {
            UI.write(entry.getKey() + " (" + entry.getValue() + ")");
        }
    }

    public Set<T> keySet() {
        return this.counts.keySet();
    }

    public List<T> sortedKeys() {
        Set<T> keys = this.counts.keySet();
        ArrayList<T> result = new ArrayList<T>(keys);
        Collections.sort(result, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return -Long.compare(Counter.this.get(o1), Counter.this.get(o2));
            }
        });
        return result;
    }

    public long get(T s) {
        Long count = this.counts.get(s);
        if (count == null) {
            return 0L;
        }
        return count;
    }

    @JsonIgnore
    public long getTotal() {
        if (this.cachedTotal == -1L) {
            this.cachedTotal = 0L;
            for (Long val : this.counts.values()) {
                this.cachedTotal += val.longValue();
            }
        }
        return this.cachedTotal;
    }

    public Set<Map.Entry<T, Long>> entrySet() {
        return this.counts.entrySet();
    }

    public Counter<T> clone() {
        Counter<T> clone = new Counter<T>();
        clone.getMap().putAll(this.getMap());
        return clone;
    }

    @JsonIgnore
    public Map<T, Long> getMap() {
        return this.counts;
    }

    public int size() {
        return this.counts.size();
    }

    public void set(T s, long value) {
        this.counts.put(s, value);
    }

    public void addAll(Counter<T> other) {
        for (Map.Entry<T, Long> entry : other.entrySet()) {
            this.inc(entry.getKey(), entry.getValue());
        }
    }

    public void addAll(List<Pair<T, Long>> values) {
        this.counts.clear();
        for (Pair<T, Long> value : values) {
            this.counts.put(value.getFirst(), value.getSecond());
        }
    }

    public void trim(int maxSize) {
        if (maxSize <= 0) {
            throw new RuntimeException("Incorrect max size:" + maxSize);
        }
        if (this.size() > maxSize) {
            List<T> sortedKeys = this.sortedKeys();
            long minCount = this.get(sortedKeys.get(sortedKeys.size() - 1));
            Set<T> allKeys = this.keySet();
            for (T key : allKeys) {
                if (this.get(key) >= minCount) continue;
                this.counts.remove(key);
            }
        }
    }

    public void clear() {
        this.counts.clear();
    }

    public List<Pair<T, Long>> getValuesAsList() {
        ArrayList<Pair<T, Long>> result = new ArrayList<Pair<T, Long>>();
        for (Map.Entry<T, Long> entry : this.counts.entrySet()) {
            result.add(new Pair<T, Long>(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public void setValuesAsList(List<Pair<T, Long>> values) {
        this.counts.clear();
        for (Pair<T, Long> value : values) {
            this.counts.put(value.getFirst(), value.getSecond());
        }
    }
}

