/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.counts;

import be.bagofwords.ui.UI;
import be.bagofwords.util.NumUtils;
import java.util.ArrayList;
import java.util.Collections;

public class BinComputer {
    private final ArrayList<Double> allValues = new ArrayList();
    private final int maxSize;

    public BinComputer(int maxSize) {
        this.maxSize = maxSize;
    }

    public void addCount(double count) {
        if (this.maxSize == -1 || this.allValues.size() < this.maxSize) {
            this.allValues.add(count);
        }
    }

    public synchronized double[] getEquiDenseBins(int size) {
        return NumUtils.getBorders(size, this.allValues);
    }

    public synchronized double[] getEquiWidthBins(int size) {
        Collections.sort(this.allValues);
        double min = this.allValues.get(0);
        double max = this.allValues.get(this.allValues.size() - 1);
        double binWidth = (max - min) / (double)size;
        double[] borders = new double[size - 1];
        for (int i = 0; i < borders.length; ++i) {
            borders[i] = min + (double)(i + 1) * binWidth;
        }
        return borders;
    }

    public int[] getBinCounts(double[] bins) {
        int[] counts = new int[bins.length + 1];
        for (Double val : this.allValues) {
            int ind;
            int n = ind = NumUtils.getBin(bins, val);
            counts[n] = counts[n] + 1;
        }
        return counts;
    }

    public void printBins(double[] bins) {
        int[] counts = this.getBinCounts(bins);
        for (int i = 0; i < counts.length; ++i) {
            if (i == 0) {
                UI.write("... to " + bins[i] + " has " + counts[i] + " instances.");
                continue;
            }
            if (i == bins.length) {
                UI.write(bins[i - 1] + " to ... has " + counts[i] + " instances.");
                continue;
            }
            UI.write(bins[i - 1] + " to " + bins[i] + " has " + counts[i] + " instances.");
        }
    }

    public ArrayList<Double> getAllValues() {
        return this.allValues;
    }
}

