/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.cache;

import be.bagofwords.cache.CacheableData;
import be.bagofwords.counts.Counter;
import be.bagofwords.util.KeyValue;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;

public class Cache<T> {
    private static final int FLUSH_BATCH_SIZE = 1000000;
    private static final int NUMBER_OF_SEGMENTS_EXPONENT = 7;
    private static final int NUMBER_OF_SEGMENTS = 128;
    private static final int NUMBER_OF_READ_PERMITS = 1000;
    private final CacheableData data;
    private final Semaphore[] locks;
    private final Map<Long, T>[] cachedObjects;
    private final Map<Long, T>[] oldCachedObjects;
    private final boolean isWriteBuffer;
    private final Class<? extends T> objectClass;
    private final T nullValue;
    private final String name;
    private int numHits;
    private int numOfFetches;
    private Map<T, T> commonValues;

    public Cache(CacheableData<T> data, boolean isWriteBuffer, String name, Class<? extends T> objectClass) {
        this.data = data;
        this.objectClass = objectClass;
        this.cachedObjects = new Map[128];
        this.createMaps(this.cachedObjects);
        this.oldCachedObjects = new Map[128];
        this.createMaps(this.oldCachedObjects);
        this.locks = new Semaphore[128];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new Semaphore(1000);
        }
        this.numHits = 0;
        this.numOfFetches = 0;
        this.commonValues = null;
        this.isWriteBuffer = isWriteBuffer;
        this.nullValue = Cache.getNullValueForType(objectClass);
        this.name = name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T get(long key) {
        this.incrementFetches();
        int segmentInd = this.getSegmentInd(key);
        this.lockRead(segmentInd);
        T result = this.cachedObjects[segmentInd].get(key);
        if (result == null) {
            result = this.oldCachedObjects[segmentInd].get(key);
            this.unlockRead(segmentInd);
            if (result == null) return null;
            this.lockWrite(segmentInd);
            this.cachedObjects[segmentInd].put(key, result);
            this.oldCachedObjects[segmentInd].remove(key);
            this.unlockWrite(segmentInd);
        } else {
            this.unlockRead(segmentInd);
        }
        this.incrementHits();
        if (!result.equals(this.nullValue)) return result;
        return null;
    }

    public void put(long key, T value) {
        if (value == null) {
            value = this.nullValue;
        } else {
            if (value.equals(this.nullValue)) {
                throw new RuntimeException("Sorry but " + value + " is a reserved value to indicate null.");
            }
            value = this.makeSharedValueIfPossible(value);
        }
        int segmentInd = this.getSegmentInd(key);
        this.lockWrite(segmentInd);
        this.cachedObjects[segmentInd].put(key, value);
        this.oldCachedObjects[segmentInd].remove(key);
        this.unlockWrite(segmentInd);
    }

    public void flush() {
        final ArrayList valuesToRemove = new ArrayList();
        this.doActionOnValues(new ValueAction(){

            public void doAction(long key, Object value) {
                valuesToRemove.add(new KeyValue<Object>(key, value));
                if (valuesToRemove.size() > 1000000) {
                    Cache.this.getData().removedValuesFromCache(Cache.this, valuesToRemove);
                    valuesToRemove.clear();
                }
            }
        });
        this.clear();
        if (!valuesToRemove.isEmpty()) {
            this.getData().removedValuesFromCache(this, valuesToRemove);
        }
    }

    public CacheableData getData() {
        return this.data;
    }

    public void clear() {
        this.lockWriteAll();
        this.createMaps(this.cachedObjects);
        this.createMaps(this.oldCachedObjects);
        this.unlockWriteAll();
    }

    public void moveCachedObjectsToOld() {
        this.lockWriteAll();
        for (int i = 0; i < this.cachedObjects.length; ++i) {
            this.oldCachedObjects[i] = this.cachedObjects[i];
        }
        this.createMaps(this.cachedObjects);
        this.unlockWriteAll();
    }

    public long size() {
        long result = 0L;
        for (Map<Long, T> map : this.cachedObjects) {
            result += (long)map.size();
        }
        return result;
    }

    public long completeSize() {
        long result = this.size();
        for (Map<Long, T> map : this.oldCachedObjects) {
            result += (long)map.size();
        }
        return result;
    }

    public void remove(long key) {
        int segmentInd = this.getSegmentInd(key);
        this.lockWrite(segmentInd);
        this.cachedObjects[segmentInd].remove(key);
        this.oldCachedObjects[segmentInd].remove(key);
        this.unlockWrite(segmentInd);
    }

    public String getName() {
        return this.name;
    }

    public int getNumberOfHits() {
        return this.numHits;
    }

    public int getNumberOfFetches() {
        return this.numOfFetches;
    }

    public boolean isWriteBuffer() {
        return this.isWriteBuffer;
    }

    private static <T> T getNullValueForType(Class<T> objectClass) {
        if (objectClass == Long.class) {
            return (T)new Long(Long.MAX_VALUE);
        }
        if (objectClass == Double.class) {
            return (T)new Double(Double.MAX_VALUE);
        }
        if (objectClass == Float.class) {
            return (T)new Float(Float.MAX_VALUE);
        }
        if (objectClass == Integer.class) {
            return (T)new Integer(Integer.MAX_VALUE);
        }
        return (T)"xxxNULLxxx";
    }

    private void lockRead(int segmentInd) {
        this.locks[segmentInd].acquireUninterruptibly(1);
    }

    private void unlockRead(int segmentInd) {
        this.locks[segmentInd].release(1);
    }

    private void lockWrite(int segmentInd) {
        this.locks[segmentInd].acquireUninterruptibly(1000);
    }

    private void unlockWrite(int segmentInd) {
        this.locks[segmentInd].release(1000);
    }

    private void lockWriteAll() {
        for (int i = 0; i < 128; ++i) {
            this.locks[i].acquireUninterruptibly(1000);
        }
    }

    private void unlockWriteAll() {
        for (int i = 0; i < 128; ++i) {
            this.locks[i].release(1000);
        }
    }

    private void doActionOnValues(ValueAction<T> valueAction) {
        for (int segmentInd = 0; segmentInd < 128; ++segmentInd) {
            this.lockRead(segmentInd);
            for (Map.Entry<Long, T> entry : this.cachedObjects[segmentInd].entrySet()) {
                T value = entry.getValue();
                if (value.equals(this.nullValue)) {
                    value = null;
                }
                valueAction.doAction(entry.getKey(), value);
            }
            this.unlockRead(segmentInd);
        }
    }

    private void incrementFetches() {
        ++this.numOfFetches;
    }

    private void incrementHits() {
        ++this.numHits;
    }

    private void createMaps(Map[] result) {
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.objectClass == Long.class ? new Long2LongOpenHashMap() : (this.objectClass == Integer.class ? new Long2IntOpenHashMap() : (this.objectClass == Float.class ? new Long2FloatOpenHashMap() : (this.objectClass == Double.class ? new Long2DoubleOpenHashMap() : new Long2ObjectOpenHashMap())));
        }
    }

    private int getSegmentInd(long key) {
        return (int)((key >> 57) + 64L);
    }

    private T makeSharedValueIfPossible(T value) {
        if (this.valueCanBeCommon(value)) {
            T commonValue;
            if (this.commonValues == null && this.size() > 10000L) {
                this.commonValues = this.computeCommonValues();
            }
            if (this.commonValues != null && (commonValue = this.commonValues.get(value)) != null) {
                return commonValue;
            }
        }
        return value;
    }

    private <T> boolean valueCanBeCommon(T value) {
        return value != null && (value instanceof String || value instanceof Byte || value instanceof Character || value instanceof Boolean);
    }

    private Map computeCommonValues() {
        final Counter counter = new Counter();
        this.doActionOnValues(new ValueAction(){

            public void doAction(long key, Object value) {
                if (counter.size() < 10000 && Cache.this.valueCanBeCommon(value)) {
                    counter.inc(value);
                }
            }
        });
        List sorted = counter.sortedKeys();
        HashMap result = new HashMap();
        for (int i = 0; i < sorted.size() && i < 1000; ++i) {
            result.put(sorted.get(i), sorted.get(i));
        }
        return result;
    }

    private static interface ValueAction<T> {
        public void doAction(long var1, T var3);
    }
}

