/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.application.status;

import be.bagofwords.application.ApplicationContextFactory;
import be.bagofwords.application.ApplicationLifeCycle;
import be.bagofwords.application.annotations.EagerBowComponent;
import be.bagofwords.application.status.StatusViewable;
import be.bagofwords.util.SpringUtils;
import be.bagofwords.web.BaseController;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import spark.Request;
import spark.Response;

@EagerBowComponent
public class HttpApplicationStatus
extends BaseController {
    @Autowired
    private ApplicationLifeCycle applicationLifeCycle;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ApplicationContextFactory applicationContextFactory;

    public HttpApplicationStatus() {
        super("/status");
    }

    protected String getOutput() throws IOException {
        StringBuilder sb = new StringBuilder();
        List<StatusViewable> statusViewables = SpringUtils.getInstantiatedBeans(this.applicationContext, StatusViewable.class);
        for (StatusViewable statusViewable : statusViewables) {
            statusViewable.printHtmlStatus(sb);
        }
        return sb.toString();
    }

    @Override
    public String handleRequest(Request request, Response response) throws IOException {
        StringBuilder sb = new StringBuilder();
        String applicationName = this.applicationContextFactory.getApplicationName();
        sb.append("<html><head><title>" + applicationName + ": application status</title></head><body>");
        sb.append(this.getOutput());
        sb.append("</body></html>");
        return sb.toString();
    }
}

