/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.application.memory;

import be.bagofwords.application.CloseableComponent;
import be.bagofwords.application.annotations.EagerBowComponent;
import be.bagofwords.application.memory.MemoryGobbler;
import be.bagofwords.application.memory.MemoryStatus;
import be.bagofwords.ui.UI;
import be.bagofwords.util.NumUtils;
import be.bagofwords.util.SafeThread;
import be.bagofwords.util.Utils;
import com.sun.management.GarbageCollectionNotificationInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

@EagerBowComponent
public class MemoryManager
implements CloseableComponent {
    private final List<MemoryGobbler> memoryGobblers = new ArrayList<MemoryGobbler>();
    private MemoryStatus memoryStatus;
    private ReentrantLock globalCleanInProgressLock = new ReentrantLock();
    private final CleanupObjectsThread cleanupObjectsThread;

    public MemoryManager() {
        this.memoryStatus = MemoryStatus.FREE;
        this.cleanupObjectsThread = new CleanupObjectsThread();
        this.cleanupObjectsThread.start();
    }

    @Override
    public void close() {
        this.cleanupObjectsThread.terminateAndWait();
    }

    public void waitForSufficientMemory() {
        if (!(this.memoryStatus != MemoryStatus.CRITICAL || this.globalCleanInProgressLock.isLocked() && this.globalCleanInProgressLock.isHeldByCurrentThread())) {
            long start = System.currentTimeMillis();
            long timeOfLastWarning = System.currentTimeMillis();
            while (this.memoryStatus == MemoryStatus.CRITICAL) {
                Utils.threadSleep(20L);
                if (System.currentTimeMillis() - timeOfLastWarning <= 30000L) continue;
                UI.writeWarning("Method has been waiting for more memory for " + (System.currentTimeMillis() - start) + " ms");
                timeOfLastWarning = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMemoryGobbler(MemoryGobbler memoryGobbler) {
        List<MemoryGobbler> list = this.memoryGobblers;
        synchronized (list) {
            this.memoryGobblers.add(memoryGobbler);
        }
    }

    public MemoryStatus getMemoryStatus() {
        return this.memoryStatus;
    }

    private MemoryStatus findStatus(long used, long max) {
        double fraction = (double)used / (double)max;
        for (int i = MemoryStatus.values().length - 1; i >= 0; --i) {
            MemoryStatus curr = MemoryStatus.values()[i];
            if (!(curr.getMinMemoryUsage() <= fraction)) continue;
            return curr;
        }
        return MemoryStatus.FREE;
    }

    private class CleanupObjectsThread
    extends SafeThread {
        private CleanupObjectsThread() {
            super("CleanObjectsThread", true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runInt() {
            Thread.currentThread().setPriority(10);
            this.registerGarbageCollectionListener();
            while (!this.isTerminateRequested()) {
                block7: {
                    try {
                        ArrayList currCollections;
                        if (MemoryManager.this.memoryStatus != MemoryStatus.LOW && MemoryManager.this.memoryStatus != MemoryStatus.CRITICAL) break block7;
                        MemoryManager.this.globalCleanInProgressLock.lock();
                        List list = MemoryManager.this.memoryGobblers;
                        synchronized (list) {
                            currCollections = new ArrayList(MemoryManager.this.memoryGobblers);
                        }
                        for (MemoryGobbler collection : currCollections) {
                            collection.freeMemory();
                        }
                        MemoryManager.this.memoryStatus = MemoryStatus.FREE;
                        System.gc();
                        MemoryManager.this.globalCleanInProgressLock.unlock();
                    }
                    catch (Throwable exp) {
                        UI.writeError("Exception in CleanObjectsThread!!!", exp);
                    }
                }
                Utils.threadSleep(50L);
            }
        }

        private void registerGarbageCollectionListener() {
            List<GarbageCollectorMXBean> gcbeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean gcbean : gcbeans) {
                NotificationEmitter emitter = (NotificationEmitter)((Object)gcbean);
                NotificationListener listener = new NotificationListener(){
                    long totalGcDuration = 0L;

                    @Override
                    public void handleNotification(Notification notification, Object handback) {
                        if (notification.getType().equals("com.sun.management.gc.notification")) {
                            GarbageCollectionNotificationInfo info = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
                            Map<String, MemoryUsage> mem = info.getGcInfo().getMemoryUsageAfterGc();
                            for (Map.Entry<String, MemoryUsage> entry : mem.entrySet()) {
                                String name = entry.getKey();
                                MemoryUsage memoryDetail = entry.getValue();
                                if (!"PS Old Gen".equals(name)) continue;
                                MemoryManager.this.memoryStatus = MemoryManager.this.findStatus(memoryDetail.getUsed(), memoryDetail.getMax());
                                if (MemoryManager.this.memoryStatus != MemoryStatus.CRITICAL) continue;
                                double overhead = (double)this.totalGcDuration / (double)info.getGcInfo().getEndTime();
                                double used = (double)memoryDetail.getUsed() / (double)memoryDetail.getMax();
                                UI.write("[Memory] status=" + (Object)((Object)MemoryManager.this.memoryStatus) + " PS Old Gen used=" + NumUtils.makeNicePercent(used) + " GC cumulated overhead " + NumUtils.makeNicePercent(overhead));
                            }
                            this.totalGcDuration += info.getGcInfo().getDuration();
                        }
                    }
                };
                emitter.addNotificationListener(listener, null, null);
            }
        }
    }
}

