/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.application.file;

import be.bagofwords.application.CloseableComponent;
import be.bagofwords.application.annotations.BowComponent;
import be.bagofwords.application.file.FilesCollection;
import be.bagofwords.ui.UI;
import be.bagofwords.util.SafeThread;
import be.bagofwords.util.Utils;
import java.util.ArrayList;
import java.util.List;

@BowComponent
public class OpenFilesManager
implements CloseableComponent {
    private static final int MAX_NUMBER_OF_OPEN_FILES = 7000;
    private final CheckOpenFilesThread checkOpenFilesThread;
    private final List<FilesCollection> filesCollections = new ArrayList<FilesCollection>();
    private int currentNumberOfOpenFiles = 0;

    public OpenFilesManager() {
        this.checkOpenFilesThread = new CheckOpenFilesThread();
        this.checkOpenFilesThread.start();
    }

    public synchronized void registerFilesCollection(FilesCollection filesCollection) {
        this.filesCollections.add(filesCollection);
    }

    @Override
    public void close() {
        this.checkOpenFilesThread.terminateAndWait();
    }

    public synchronized void registerOpenFile() {
        ++this.currentNumberOfOpenFiles;
        long lastStatusMessage = System.currentTimeMillis();
        while (this.currentNumberOfOpenFiles > 7000) {
            Utils.threadSleep(100L);
            if (System.currentTimeMillis() - lastStatusMessage <= 10000L) continue;
            UI.write("Method is waiting to open a new file...");
            lastStatusMessage = System.currentTimeMillis();
        }
    }

    public synchronized void registerClosedFile() {
        --this.currentNumberOfOpenFiles;
    }

    public class CheckOpenFilesThread
    extends SafeThread {
        public CheckOpenFilesThread() {
            super("CheckOpenFilesThread", true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void runInt() throws Exception {
            while (!this.isTerminateRequested()) {
                CheckOpenFilesThread checkOpenFilesThread = this;
                synchronized (checkOpenFilesThread) {
                    if ((double)OpenFilesManager.this.currentNumberOfOpenFiles / 7000.0 > 0.8) {
                        for (int i = 0; i < OpenFilesManager.this.filesCollections.size() && !this.isTerminateRequested(); ++i) {
                            FilesCollection filesCollection = (FilesCollection)OpenFilesManager.this.filesCollections.get(i);
                            filesCollection.closeOpenFiles(1.0);
                        }
                    }
                }
                Utils.threadSleep(100L);
            }
        }
    }
}

