/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.application;

import be.bagofwords.application.ApplicationContextFactory;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;

public abstract class BaseApplicationContextFactory
implements ApplicationContextFactory {
    private AnnotationConfigApplicationContext applicationContext;

    protected BaseApplicationContextFactory() {
        BaseApplicationContextFactory.setSaneDefaultsForLog4J();
        this.applicationContext = new AnnotationConfigApplicationContext();
    }

    protected BaseApplicationContextFactory resourceResolver(ResourcePatternResolver resourcePatternResolver) {
        this.applicationContext.setResourceLoader((ResourceLoader)resourcePatternResolver);
        return this;
    }

    protected BaseApplicationContextFactory classLoader(ClassLoader classLoader) {
        this.applicationContext.setClassLoader(classLoader);
        return this;
    }

    protected BaseApplicationContextFactory singleton(String name, Object object) {
        this.applicationContext.getBeanFactory().registerSingleton(name, object);
        return this;
    }

    protected BaseApplicationContextFactory bean(Class _class) {
        this.applicationContext.register(new Class[]{_class});
        return this;
    }

    protected BaseApplicationContextFactory scan(String prefix) {
        this.applicationContext.scan(new String[]{prefix});
        return this;
    }

    @Override
    public AnnotationConfigApplicationContext createApplicationContext() {
        this.singleton("applicationContextFactory", this);
        this.applicationContext.refresh();
        this.applicationContext.registerShutdownHook();
        return this.applicationContext;
    }

    @Override
    public String getApplicationName() {
        return "";
    }

    private static void setSaneDefaultsForLog4J() {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.WARN);
    }
}

