/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.application;

import be.bagofwords.application.CloseableComponent;
import be.bagofwords.application.LateCloseableComponent;
import be.bagofwords.application.annotations.EagerBowComponent;
import be.bagofwords.util.SpringUtils;
import be.bagofwords.util.Utils;
import java.io.Closeable;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextStoppedEvent;

@EagerBowComponent
public class ApplicationLifeCycle
implements ApplicationListener<ContextStoppedEvent> {
    private boolean applicationWasTerminated = false;
    @Autowired
    private ApplicationContext applicationContext;

    public synchronized void terminateApplication() {
        if (!this.applicationWasTerminated) {
            List<CloseableComponent> terminatableBeans = SpringUtils.getInstantiatedBeans(this.applicationContext, CloseableComponent.class);
            for (CloseableComponent object : terminatableBeans) {
                if (object instanceof LateCloseableComponent) continue;
                IOUtils.closeQuietly((Closeable)object);
            }
            for (CloseableComponent object : terminatableBeans) {
                if (!(object instanceof LateCloseableComponent)) continue;
                IOUtils.closeQuietly((Closeable)object);
            }
            this.applicationWasTerminated = true;
        }
    }

    public void waitUntilTerminated() {
        while (!this.applicationWasTerminated) {
            Utils.threadSleep(500L);
        }
    }

    public void onApplicationEvent(ContextStoppedEvent event) {
        this.terminateApplication();
    }
}

