/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.text;

import be.bagofwords.text.SimpleString;
import be.bagofwords.text.Text;
import be.bagofwords.ui.UI;
import be.bagofwords.util.Pair;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;

public class MappedText
implements Serializable,
Text {
    public transient char[] text;
    public String url;
    private int[] mappingToOrig;

    public MappedText(char[] text, int[] mappingToOrig, String url) {
        this.text = text;
        this.mappingToOrig = mappingToOrig;
        this.url = url;
    }

    public MappedText() {
    }

    public MappedText(char[] text, String url) {
        this.text = text;
        this.mappingToOrig = new int[text.length];
        for (int i = 0; i < text.length; ++i) {
            this.mappingToOrig[i] = i;
        }
        this.url = url;
    }

    @JsonIgnore
    public char[] getTextArray() {
        return this.text;
    }

    public void setText(char[] text) {
        this.text = text;
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.url;
    }

    public void setId(String id) {
    }

    @JsonIgnore
    public String getS() {
        return new String(this.text);
    }

    public void setText(String text) {
        this.text = text.toCharArray();
    }

    @Override
    @JsonIgnore
    public String getText() {
        return new String(this.text);
    }

    public void setFileName(String fileName) {
        this.url = StringUtils.isEmpty((CharSequence)this.url) ? fileName : this.url + "/" + fileName;
    }

    public void setPath(String path) {
        this.url = StringUtils.isEmpty((CharSequence)this.url) ? path : path + "/" + this.url;
    }

    public int[] getMappingToOrig() {
        return this.mappingToOrig;
    }

    public void setMappingToOrig(int[] mappingToOrig) {
        this.mappingToOrig = mappingToOrig;
    }

    public String toString() {
        return this.url;
    }

    private int getInverseMapping(int position) {
        for (int i = 0; i < this.mappingToOrig.length; ++i) {
            if (this.mappingToOrig[i] != position) continue;
            return i;
        }
        return -1;
    }

    public Pair<Integer, Integer> getMappingToOrig(SimpleString string) {
        return this.getMappingToOrig(string.getStart(), string.getEnd());
    }

    public Pair<Integer, Integer> getMappingToOrig(int startPos, int endPos) {
        int mappedEnd;
        int mappedStart = startPos < this.mappingToOrig.length ? this.mappingToOrig[startPos] : -1;
        int n = mappedEnd = endPos < this.mappingToOrig.length ? this.mappingToOrig[--endPos] : -1;
        if (mappedEnd != -1) {
            ++mappedEnd;
        }
        return new Pair<Integer, Integer>(mappedStart, mappedEnd);
    }

    public Pair<Integer, Integer> getMappingFromOrig(int startPos, int endPos) {
        int origStart = this.getInverseMapping(startPos);
        int origEnd = this.getInverseMapping(endPos);
        return new Pair<Integer, Integer>(origStart, origEnd);
    }

    public void printMapping(String orig) {
        for (int i = 0; i < this.text.length; ++i) {
            Pair<Integer, Integer> mapping = this.getMappingToOrig(i, i + 1);
            if (mapping.getFirst() != -1 && mapping.getSecond() != -1) {
                UI.write(this.text[i] + " " + orig.substring(mapping.getFirst(), mapping.getSecond()));
                continue;
            }
            UI.write(Character.valueOf(this.text[i]));
        }
    }

    public void printInverseMapping(String orig) {
        String curr = new String(this.text);
        for (int i = 0; i < orig.length(); ++i) {
            Pair<Integer, Integer> mapping = this.getMappingFromOrig(i, i + 1);
            if (mapping.getFirst() == -1 || mapping.getSecond() == -1) {
                UI.write(Character.valueOf(orig.charAt(i)));
                continue;
            }
            UI.write(orig.charAt(i) + " " + curr.substring(mapping.getFirst(), mapping.getSecond()));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof MappedText) {
            MappedText otherFile = (MappedText)obj;
            return this.getUrl().equals(otherFile.getUrl());
        }
        return false;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

