/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.iterator;

import be.bagofwords.iterator.CloseableIterator;
import java.util.List;

public class SequentialIteratorOfIterators<U>
extends CloseableIterator<U> {
    private final List<CloseableIterator<? extends U>> iterators;
    private int currPos;
    private U next;

    public SequentialIteratorOfIterators(List<CloseableIterator<? extends U>> iterators) {
        this.iterators = iterators;
        this.currPos = 0;
        this.next = this.findNext();
    }

    private U findNext() {
        while (this.currPos < this.iterators.size()) {
            if (this.iterators.get(this.currPos).hasNext()) {
                return (U)this.iterators.get(this.currPos).next();
            }
            ++this.currPos;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public synchronized U next() {
        U result = this.next;
        this.next = this.findNext();
        return result;
    }

    @Override
    public void closeInt() {
        for (CloseableIterator<U> iterator : this.iterators) {
            iterator.close();
        }
    }
}

