/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.counts;

import java.util.Arrays;

public class SparseVector {
    public int[] inds = new int[0];
    public float[] vals = new float[0];
    public int size = 0;

    public void addValue(int ind, float value) {
        int currInd = -1;
        for (int i = 0; i < this.inds.length; ++i) {
            if (this.inds[i] != ind) continue;
            currInd = i;
        }
        if (currInd != -1) {
            int n = currInd;
            this.vals[n] = this.vals[n] + value;
        } else {
            if (this.size >= this.inds.length) {
                this.inds = Arrays.copyOf(this.inds, this.inds.length * 2 + 1);
                this.vals = Arrays.copyOf(this.vals, this.vals.length * 2 + 1);
            }
            this.inds[this.size] = ind;
            this.vals[this.size] = value;
            ++this.size;
        }
    }

    public double get(int ind) {
        for (int i = 0; i < this.inds.length; ++i) {
            if (this.inds[i] != ind) continue;
            return this.vals[i];
        }
        return 0.0;
    }

    public void trim(int newSize) {
        if (newSize < this.size) {
            float[] newVals = Arrays.copyOf(this.vals, this.size);
            Arrays.sort(newVals);
            int[] newInds = new int[newSize];
            float smallestVal = newVals[0];
            for (int i = 0; i < newSize; ++i) {
                double val = newVals[newVals.length - i - 1];
                for (int j = 0; j < this.size; ++j) {
                    if ((double)this.vals[j] != val) continue;
                    newInds[i] = this.inds[j];
                    this.vals[j] = smallestVal;
                }
            }
            this.inds = newInds;
            this.vals = Arrays.copyOfRange(newVals, this.size - newSize, this.size);
            this.size = newSize;
        }
    }

    public String toString() {
        String result = "[ ";
        for (int i = 0; i < this.size; ++i) {
            result = result + this.inds[i] + "=" + this.vals[i];
            if (i >= this.size - 1) continue;
            result = result + ", ";
        }
        result = result + "]";
        return result;
    }

    public void addValues(SparseVector vector) {
        for (int i = 0; i < vector.size; ++i) {
            this.addValue(vector.inds[i], vector.vals[i]);
        }
    }
}

