/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.application.status;

import be.bagofwords.application.ApplicationContextFactory;
import be.bagofwords.application.status.RegisterUrlsServer;
import be.bagofwords.application.status.RemoteRegisterUrlsServerProperties;
import be.bagofwords.util.SpringUtils;
import be.bagofwords.util.WrappedSocketConnection;
import be.bagofwords.web.BaseController;
import be.bagofwords.web.WebContainer;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextStartedEvent;

public class RegisterUrlsClient
implements ApplicationListener<ContextStartedEvent> {
    @Autowired
    private RemoteRegisterUrlsServerProperties properties;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ApplicationContextFactory applicationContextFactory;
    @Autowired
    private WebContainer webContainer;

    public void onApplicationEvent(ContextStartedEvent contextStartedEvent) {
        List<BaseController> controllers = SpringUtils.getInstantiatedBeans(this.applicationContext, BaseController.class);
        for (BaseController controller : controllers) {
            this.registerPath(this.properties.getApplicationUrlRoot() + ":" + this.webContainer.getPort() + controller.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPath(String path) {
        WrappedSocketConnection connection = null;
        try {
            connection = new WrappedSocketConnection(this.properties.getDatabaseServerAddress(), this.properties.getRegisterUrlServerPort());
            connection.writeByte(RegisterUrlsServer.SEND_URL);
            connection.writeString(this.applicationContextFactory.getApplicationName());
            connection.writeString(path);
            connection.flush();
            long result = connection.readLong();
            if (result != 0x7FFFFFFFFFFFFFFEL) {
                throw new RuntimeException("Unexpected response " + result);
            }
            IOUtils.closeQuietly((Closeable)connection);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(connection);
        }
    }
}

