/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.application.memory;

import be.bagofwords.application.CloseableComponent;
import be.bagofwords.application.annotations.EagerBowComponent;
import be.bagofwords.application.memory.HeapDumper;
import be.bagofwords.application.memory.MemoryGobbler;
import be.bagofwords.application.memory.MemoryStatus;
import be.bagofwords.ui.UI;
import be.bagofwords.util.SafeThread;
import be.bagofwords.util.Utils;
import com.sun.management.GarbageCollectionNotificationInfo;
import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

@EagerBowComponent
public class MemoryManager
implements CloseableComponent {
    private final List<MemoryGobbler> memoryGobblers = new ArrayList<MemoryGobbler>();
    private MemoryStatus memoryStatus;
    private ReentrantLock globalCleanInProgressLock = new ReentrantLock();
    private final FreeMemoryThread freeMemoryThread;
    private boolean dumpHeapToFileWhenMemoryFull;

    public MemoryManager() {
        this.memoryStatus = MemoryStatus.FREE;
        this.freeMemoryThread = new FreeMemoryThread();
        this.freeMemoryThread.start();
    }

    public boolean getDumpHeapToFileWhenMemoryFull() {
        return this.dumpHeapToFileWhenMemoryFull;
    }

    public void setDumpHeapToFileWhenMemoryFull(boolean dumpHeapToFileWhenMemoryFull) {
        this.dumpHeapToFileWhenMemoryFull = dumpHeapToFileWhenMemoryFull;
    }

    @Override
    public void terminate() {
        this.freeMemoryThread.terminateAndWaitForFinish();
    }

    public void waitForSufficientMemory() {
        if (!(this.memoryStatus != MemoryStatus.CRITICAL || this.globalCleanInProgressLock.isLocked() && this.globalCleanInProgressLock.isHeldByCurrentThread())) {
            long start = System.currentTimeMillis();
            long timeOfLastWarning = System.currentTimeMillis();
            while (this.memoryStatus == MemoryStatus.CRITICAL) {
                Utils.threadSleep(20L);
                if (System.currentTimeMillis() - timeOfLastWarning <= 30000L) continue;
                UI.writeWarning("Method has been waiting for more memory for " + (System.currentTimeMillis() - start) + " ms");
                timeOfLastWarning = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMemoryGobbler(MemoryGobbler memoryGobbler) {
        List<MemoryGobbler> list = this.memoryGobblers;
        synchronized (list) {
            this.memoryGobblers.add(memoryGobbler);
        }
    }

    public MemoryStatus getMemoryStatus() {
        return this.memoryStatus;
    }

    private MemoryStatus findStatus(long used, long max) {
        double fraction = (double)used / (double)max;
        for (int i = MemoryStatus.values().length - 1; i >= 0; --i) {
            MemoryStatus curr = MemoryStatus.values()[i];
            if (!(curr.getMinMemoryUsage() <= fraction)) continue;
            return curr;
        }
        return MemoryStatus.FREE;
    }

    private class FreeMemoryThread
    extends SafeThread {
        private FreeMemoryThread() {
            super("FreeMemoryThread", true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runInt() {
            Thread.currentThread().setPriority(10);
            this.registerGarbageCollectionListener();
            while (!this.isTerminateRequested()) {
                block10: {
                    try {
                        ArrayList currCollections;
                        if (MemoryManager.this.memoryStatus != MemoryStatus.LOW && MemoryManager.this.memoryStatus != MemoryStatus.CRITICAL) break block10;
                        MemoryManager.this.globalCleanInProgressLock.lock();
                        if (MemoryManager.this.dumpHeapToFileWhenMemoryFull) {
                            File dumpFile = new File("heap_" + System.currentTimeMillis() + ".bin");
                            HeapDumper.dumpHeap(dumpFile.getAbsolutePath(), false);
                            UI.write("Heap dumped to " + dumpFile.getAbsolutePath());
                        }
                        Iterator iterator = MemoryManager.this.memoryGobblers;
                        synchronized (iterator) {
                            currCollections = new ArrayList(MemoryManager.this.memoryGobblers);
                        }
                        if (MemoryManager.this.memoryStatus == MemoryStatus.CRITICAL) {
                            UI.write("[Memory] Memory critical! Printing usage:");
                            for (MemoryGobbler memoryGobbler : MemoryManager.this.memoryGobblers) {
                                UI.write("[Memory] " + memoryGobbler.getClass().getSimpleName() + " " + memoryGobbler.getMemoryUsage());
                            }
                        }
                        for (MemoryGobbler collection : currCollections) {
                            collection.freeMemory();
                        }
                        MemoryManager.this.memoryStatus = MemoryStatus.FREE;
                        System.gc();
                        MemoryManager.this.globalCleanInProgressLock.unlock();
                    }
                    catch (Throwable exp) {
                        UI.writeError("Exception in CleanObjectsThread!!!", exp);
                    }
                }
                Utils.threadSleep(50L);
            }
        }

        private void registerGarbageCollectionListener() {
            List<GarbageCollectorMXBean> gcbeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean gcbean : gcbeans) {
                NotificationEmitter emitter = (NotificationEmitter)((Object)gcbean);
                NotificationListener listener = new NotificationListener(){
                    long totalGcDuration = 0L;

                    @Override
                    public void handleNotification(Notification notification, Object handback) {
                        if (notification.getType().equals("com.sun.management.gc.notification")) {
                            GarbageCollectionNotificationInfo info = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
                            Map<String, MemoryUsage> mem = info.getGcInfo().getMemoryUsageAfterGc();
                            for (Map.Entry<String, MemoryUsage> entry : mem.entrySet()) {
                                String name = entry.getKey();
                                MemoryUsage memoryDetail = entry.getValue();
                                if (!"PS Old Gen".equals(name)) continue;
                                MemoryManager.this.memoryStatus = MemoryManager.this.findStatus(memoryDetail.getUsed(), memoryDetail.getMax());
                            }
                            this.totalGcDuration += info.getGcInfo().getDuration();
                        }
                    }
                };
                emitter.addNotificationListener(listener, null, null);
            }
        }
    }
}

