/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.application;

import be.bagofwords.ui.UI;
import be.bagofwords.util.SafeThread;
import be.bagofwords.util.Utils;
import be.bagofwords.util.WrappedSocketConnection;
import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public abstract class BaseServer
extends SafeThread {
    public static final String ENCODING = "UTF-8";
    public static final long LONG_ERROR = Long.MAX_VALUE;
    public static final long LONG_OK = 0x7FFFFFFFFFFFFFFEL;
    public static final long LONG_END = 0x7FFFFFFFFFFFFFFDL;
    private ServerSocket serverSocket;
    private final List<SocketRequestHandler> runningRequestHandlers = new ArrayList<SocketRequestHandler>();
    private final int scpPort;
    private int totalNumberOfConnections;

    public BaseServer(String name, int port) {
        super(name, false);
        this.scpPort = port;
        this.totalNumberOfConnections = 0;
        try {
            this.serverSocket = new ServerSocket(this.scpPort);
        }
        catch (IOException exp) {
            throw new RuntimeException("Failed to initialize server " + this.getName() + " on port " + this.scpPort, exp);
        }
    }

    protected abstract SocketRequestHandler createSocketRequestHandler(WrappedSocketConnection var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runInt() throws Exception {
        UI.write("Started server " + this.getName() + " on port " + this.scpPort);
        while (!this.serverSocket.isClosed() && !this.isTerminateRequested()) {
            try {
                WrappedSocketConnection connection = new WrappedSocketConnection(this.serverSocket.accept());
                SocketRequestHandler handler = this.createSocketRequestHandler(connection);
                if (handler != null) {
                    List<SocketRequestHandler> list = this.runningRequestHandlers;
                    synchronized (list) {
                        this.runningRequestHandlers.add(handler);
                    }
                    handler.start();
                }
                ++this.totalNumberOfConnections;
            }
            catch (IOException e) {
                if (e instanceof SocketException || this.isTerminateRequested()) continue;
                UI.writeError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTerminate() {
        IOUtils.closeQuietly((ServerSocket)this.serverSocket);
        while (!this.runningRequestHandlers.isEmpty()) {
            List<SocketRequestHandler> list = this.runningRequestHandlers;
            synchronized (list) {
                for (SocketRequestHandler requestHandler : this.runningRequestHandlers) {
                    if (requestHandler.isTerminateRequested()) continue;
                    requestHandler.terminate();
                }
            }
            Utils.threadSleep(10L);
        }
        UI.write("Server " + this.getName() + " has been terminated.");
    }

    public int getTotalNumberOfConnections() {
        return this.totalNumberOfConnections;
    }

    public List<SocketRequestHandler> getRunningRequestHandlers() {
        return this.runningRequestHandlers;
    }

    public abstract class SocketRequestHandler
    extends SafeThread {
        protected WrappedSocketConnection connection;

        public SocketRequestHandler(WrappedSocketConnection connection) throws IOException {
            super(BaseServer.this.getName() + "RequestHandler", false);
            this.connection = connection;
        }

        protected abstract void reportUnexpectedError(Exception var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void runInt() {
            block5: {
                try {
                    this.handleRequests();
                }
                catch (Exception ex) {
                    if (!this.isUnexpectedError(ex)) break block5;
                    this.reportUnexpectedError(ex);
                }
            }
            IOUtils.closeQuietly((Closeable)this.connection);
            List list = BaseServer.this.runningRequestHandlers;
            synchronized (list) {
                BaseServer.this.runningRequestHandlers.remove(this);
            }
        }

        protected abstract void handleRequests() throws Exception;

        @Override
        public void doTerminate() {
            IOUtils.closeQuietly((Closeable)this.connection);
        }

        protected boolean isUnexpectedError(Exception ex) {
            if (ex.getMessage() != null && ex.getMessage().contains("Connection reset")) {
                return false;
            }
            for (StackTraceElement el : ex.getStackTrace()) {
                if (!el.getMethodName().equals("readNextAction")) continue;
                return false;
            }
            return true;
        }

        public abstract long getTotalNumberOfRequests();
    }
}

