/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.application;

import be.bagofwords.application.CloseableComponent;
import be.bagofwords.application.LateCloseableComponent;
import be.bagofwords.application.annotations.EagerBowComponent;
import be.bagofwords.util.SafeThread;
import be.bagofwords.util.SpringUtils;
import be.bagofwords.util.Utils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

@EagerBowComponent
public class ApplicationLifeCycle
implements ApplicationListener<ContextClosedEvent> {
    private boolean applicationWasTerminated = false;
    @Autowired
    private ApplicationContext applicationContext;

    public synchronized void terminateApplication() {
        if (!this.applicationWasTerminated) {
            List<CloseableComponent> terminatableBeans = SpringUtils.getInstantiatedBeans(this.applicationContext, CloseableComponent.class);
            for (CloseableComponent object : terminatableBeans) {
                if (object instanceof LateCloseableComponent) continue;
                object.terminate();
            }
            for (CloseableComponent object : terminatableBeans) {
                if (object instanceof LateCloseableComponent || !(object instanceof SafeThread)) continue;
                ((SafeThread)object).waitForFinish();
            }
            for (CloseableComponent object : terminatableBeans) {
                if (!(object instanceof LateCloseableComponent)) continue;
                object.terminate();
            }
            for (CloseableComponent object : terminatableBeans) {
                if (!(object instanceof LateCloseableComponent) || !(object instanceof SafeThread)) continue;
                ((SafeThread)object).waitForFinish();
            }
            this.applicationWasTerminated = true;
        }
    }

    public void waitUntilTerminated() {
        while (!this.applicationWasTerminated) {
            Utils.threadSleep(500L);
        }
    }

    public boolean applicationWasTerminated() {
        return this.applicationWasTerminated;
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        this.terminateApplication();
    }
}

