/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.util;

import be.bagofwords.ui.UI;
import be.bagofwords.util.SerializationUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class WrappedSocketConnection
implements Closeable {
    private Socket socket;
    private DataInputStream is;
    private DataOutputStream os;
    private boolean debug;

    public WrappedSocketConnection(String host, int port) throws IOException {
        this(host, port, false);
    }

    public WrappedSocketConnection(String host, int port, boolean useLargeOutputBuffer) throws IOException {
        this(new Socket(host, port), useLargeOutputBuffer);
    }

    public WrappedSocketConnection(Socket socket) throws IOException {
        this(socket, false);
    }

    public WrappedSocketConnection(Socket socket, boolean useLargeOutputBuffer) throws IOException {
        this.socket = socket;
        this.is = new DataInputStream(new BufferedInputStream(socket.getInputStream(), 32768));
        this.os = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), useLargeOutputBuffer ? 0x100000 : 32768));
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public DataInputStream getIs() {
        return this.is;
    }

    public DataOutputStream getOs() {
        return this.os;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.os.flush();
        this.socket.close();
    }

    public void writeLong(long value) throws IOException {
        if (this.debug) {
            UI.write("RI --> " + value);
        }
        this.os.writeLong(value);
    }

    public void writeInt(int value) throws IOException {
        if (this.debug) {
            UI.write("RI --> " + value);
        }
        this.os.writeInt(value);
    }

    public long readLong() throws IOException {
        long value = this.is.readLong();
        if (this.debug) {
            UI.write("RI <-- " + value);
        }
        return value;
    }

    public int readInt() throws IOException {
        int value = this.is.readInt();
        if (this.debug) {
            UI.write("RI <-- " + value);
        }
        return value;
    }

    public double readDouble() throws IOException {
        double value = this.is.readDouble();
        if (this.debug) {
            UI.write("RI <-- " + value);
        }
        return value;
    }

    public void writeDouble(double value) throws IOException {
        if (this.debug) {
            UI.write("RI --> " + value);
        }
        this.os.writeDouble(value);
    }

    public void writeByte(byte value) throws IOException {
        if (this.debug) {
            UI.write("RI --> " + value);
        }
        this.os.writeByte(value);
    }

    public byte readByte() throws IOException {
        byte value = this.is.readByte();
        if (this.debug) {
            UI.write("RI <-- " + value);
        }
        return value;
    }

    public void writeFloat(float value) throws IOException {
        if (this.debug) {
            UI.write("RI --> " + value);
        }
        this.os.writeFloat(value);
    }

    public float readFloat() throws IOException {
        float value = this.is.readFloat();
        if (this.debug) {
            UI.write("RI <-- " + value);
        }
        return value;
    }

    public <T> T readValue(Class<T> objectClass) throws IOException {
        int extraBytesRead;
        int length = SerializationUtils.getWidth(objectClass);
        if (length < 0) {
            length = this.readInt();
        }
        byte[] value = new byte[length];
        for (int numOfBytesRead = this.is.read(value); numOfBytesRead < length; numOfBytesRead += extraBytesRead) {
            extraBytesRead = this.is.read(value, numOfBytesRead, value.length - numOfBytesRead);
            if (extraBytesRead != -1) continue;
            throw new RuntimeException("Expected to read " + length + " bytes and received " + numOfBytesRead + " bytes");
        }
        if (this.debug) {
            UI.write("RI <-- " + value.length + " bytes");
        }
        T result = SerializationUtils.bytesToObjectCheckForNull(value, objectClass);
        return result;
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public <T> void writeValue(T value, Class<T> objectClass) throws IOException {
        byte[] objectAsBytes = SerializationUtils.objectToBytesCheckForNull(value, objectClass);
        int width = SerializationUtils.getWidth(objectClass);
        if (width == -1) {
            this.writeInt(objectAsBytes.length);
        }
        if (this.debug) {
            UI.write("RI --> " + objectAsBytes.length + " bytes");
        }
        this.os.write(objectAsBytes);
    }

    public byte[] readByteArray() throws IOException {
        int length = this.is.readInt();
        if (length > 50000000) {
            UI.write("About to read a byte array of length " + length);
        }
        byte[] bytes = new byte[length];
        this.is.readFully(bytes);
        if (this.debug) {
            String message = new String(bytes, "UTF-8");
            UI.write("RI <-- " + message.substring(0, Math.min(message.length(), 200)).replaceAll("\\W", "."));
        }
        return bytes;
    }

    public String readString() throws IOException {
        return new String(this.readByteArray(), "UTF-8");
    }

    public void writeByteArray(byte[] bytes) throws IOException {
        if (this.debug) {
            String message = new String(bytes, "UTF-8");
            UI.write("RI --> " + message.substring(0, Math.min(message.length(), 200)).replaceAll("\\W", "."));
        }
        if ((double)bytes.length > 1.0E9) {
            throw new RuntimeException("Currently objects larger then 1 GB are not supported...");
        }
        this.os.writeInt(bytes.length);
        this.os.write(bytes);
    }

    public void writeString(String message) throws IOException {
        byte[] bytes = message.getBytes("UTF-8");
        this.writeByteArray(bytes);
    }

    public boolean readBoolean() throws IOException {
        boolean result = this.is.readBoolean();
        if (this.debug) {
            UI.write("RI <-- " + result);
        }
        return result;
    }

    public void writeBoolean(boolean value) throws IOException {
        if (this.debug) {
            UI.write("RI --> " + value);
        }
        this.os.writeBoolean(value);
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }
}

