/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.util;

import be.bagofwords.ui.UI;
import be.bagofwords.util.Filter;
import be.bagofwords.util.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Utils {
    private static final int[] starts = new int[5];

    public static <T> ArrayList<T> list() {
        return new ArrayList();
    }

    public static int minFraq(int value, int divisor) {
        int result = value / divisor;
        if (value % divisor != 0) {
            return result + 1;
        }
        return result;
    }

    public static int minLog(int val) {
        int exp = 0;
        for (int currVal = 1; currVal < val; currVal *= 2) {
            ++exp;
        }
        return exp;
    }

    public static int readInt(byte[] data, int position, int numOfBytes) {
        int result = 0;
        for (int i = 0; i < numOfBytes; ++i) {
            result = i > 0 ? result << 8 | data[position + i] & 0xFF : result << 8 | data[position + i];
        }
        return result;
    }

    public static void writeInt(byte[] data, int position, int value, int numOfBytes) {
        for (int i = numOfBytes - 1; i >= 0; --i) {
            data[position + i] = (byte)value;
            value >>= 8;
        }
    }

    public static String getIP() {
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface iface : Collections.list(ifaces)) {
                if (iface.isLoopback()) continue;
                Enumeration<InetAddress> raddrs = iface.getInetAddresses();
                for (InetAddress raddr : Collections.list(raddrs)) {
                    String ip = raddr.toString().replaceFirst("/", "");
                    if (!ip.matches("\\d+\\.\\d+\\.\\d+\\.\\d+")) continue;
                    return ip;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return "127.0.0.1";
    }

    public static String getGitVersion() {
        File file = new File(".git/logs/HEAD");
        if (file.exists()) {
            String lastLine = Utils.readLastLine(file);
            String[] parts = lastLine.split(" ");
            return parts[1];
        }
        throw new RuntimeException("Could not find .git directory!");
    }

    private static String readLastLine(File file) {
        String lastLine = null;
        try {
            String line;
            BufferedReader rdr = new BufferedReader(new FileReader(file));
            while ((line = rdr.readLine()) != null) {
                lastLine = line;
            }
            return lastLine;
        }
        catch (IOException exp) {
            throw new RuntimeException(exp);
        }
    }

    public static <T extends Comparable, S> ArrayList<Pair<T, S>> reverseList(HashMap<S, T> map) {
        ArrayList<Pair<T, S>> result = new ArrayList<Pair<T, S>>();
        for (Map.Entry<S, T> entry : map.entrySet()) {
            result.add(new Pair<T, S>(entry.getValue(), entry.getKey()));
        }
        return result;
    }

    public static <S extends Comparable, T> ArrayList<Pair<S, T>> list(HashMap<S, T> map) {
        ArrayList<Pair<S, T>> result = new ArrayList<Pair<S, T>>();
        for (Map.Entry<S, T> entry : map.entrySet()) {
            result.add(new Pair<S, T>(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public static <T> ArrayList<T> list(List<T> origList, T obj) {
        ArrayList<T> result = new ArrayList<T>(origList);
        result.add(obj);
        return result;
    }

    public static <T> ArrayList<T> list(T ... objs) {
        ArrayList result = new ArrayList();
        Collections.addAll(result, objs);
        return result;
    }

    public static <S, T> Pair<S, T> pair(S obj1, T obj2) {
        return new Pair<S, T>(obj1, obj2);
    }

    public static <T, S> HashMap<T, S> map() {
        return new HashMap();
    }

    public static <T, S> HashMap<T, S> map(ArrayList<Pair<T, S>> values) {
        HashMap<T, S> res = Utils.map();
        for (Pair<T, S> val : values) {
            res.put(val.getFirst(), val.getSecond());
        }
        return res;
    }

    public static String getStackTrace(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.getBuffer().toString();
    }

    public static void threadSleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            UI.writeError(e);
        }
    }

    public static <T> List<T> filter(List<T> list, Filter<T> filter) {
        ArrayList<T> result = new ArrayList<T>();
        for (T obj : list) {
            if (!filter.accept(obj)) continue;
            result.add(obj);
        }
        return result;
    }

    public static void addLibraryPath(String pathToAdd) {
        try {
            String[] paths;
            Field usrPathsField = ClassLoader.class.getDeclaredField("usr_paths");
            usrPathsField.setAccessible(true);
            for (String path : paths = (String[])usrPathsField.get(null)) {
                if (!path.equals(pathToAdd)) continue;
                return;
            }
            String[] newPaths = Arrays.copyOf(paths, paths.length + 1);
            newPaths[newPaths.length - 1] = pathToAdd;
            usrPathsField.set(null, newPaths);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        for (int i = 1; i <= 4; ++i) {
            Utils.starts[i] = -(1 << i * 8 - 1);
        }
    }
}

