/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLUtils {
    static final Pattern linkP = Pattern.compile("(?<=href=)[^>\n ]+");
    public static final Pattern protocolP = Pattern.compile("^[A-Za-z]{3,10}://");

    public static String makeAbsolute(String url, String context) {
        int posSlash;
        if (url.startsWith("/")) {
            return URLUtils.getDomain(context) + url;
        }
        for (posSlash = context.length() - 1; posSlash >= 0 && context.charAt(posSlash) != '/'; --posSlash) {
        }
        if (posSlash >= 0) {
            context = context.substring(0, posSlash);
        }
        while (url.startsWith("../") || url.startsWith("./")) {
            if (url.startsWith("./")) {
                url = url.substring(2);
                continue;
            }
            for (posSlash = context.length() - 2; posSlash >= 0 && context.charAt(posSlash) != '/'; --posSlash) {
            }
            url = url.substring(3);
            if (posSlash < 0) continue;
            context = context.substring(0, posSlash);
        }
        return context + "/" + url;
    }

    public static String getSuperDomain(String url) {
        int start;
        url = URLUtils.getDomain(url);
        int numOfDotsPassed = 0;
        for (start = url.length() - 1; start >= 0 && (numOfDotsPassed < 1 || url.charAt(start) != '.'); --start) {
            if (url.charAt(start) != '.') continue;
            ++numOfDotsPassed;
        }
        url = url.substring(start + 1);
        return url;
    }

    public static String getDomain(String url) {
        int end;
        url = URLUtils.removeProtocol(url.toLowerCase());
        for (end = 0; end < url.length() && url.charAt(end) != '/' && url.charAt(end) != '?'; ++end) {
        }
        return url.substring(0, end);
    }

    public static String getPath(String url) {
        int end;
        url = URLUtils.removeProtocol(url);
        for (end = 0; end < url.length() && url.charAt(end) != '/' && url.charAt(end) != '?'; ++end) {
        }
        if (end < url.length()) {
            return url.substring(end);
        }
        return "/";
    }

    public static ArrayList<String> findLinks(CharSequence html, String context) {
        Matcher m = linkP.matcher(html);
        ArrayList<String> result = new ArrayList<String>();
        while (m.find()) {
            Matcher pM;
            String link = m.group();
            if (link.startsWith("&qout;")) {
                link = link.substring(6);
            }
            if (link.endsWith("&qout;")) {
                link = link.substring(0, link.length() - 6);
            }
            if (!((link = link.replaceAll("\\\\", "")).isEmpty() || link.charAt(0) != '\"' && link.charAt(0) != '\'')) {
                link = link.substring(1);
            }
            if (!(link.isEmpty() || link.charAt(link.length() - 1) != '\"' && link.charAt(link.length() - 1) != '\'')) {
                link = link.substring(0, link.length() - 1);
            }
            int posOfHash = -1;
            for (int i = 0; i < link.length(); ++i) {
                if (link.charAt(i) != '#') continue;
                posOfHash = i;
            }
            if (posOfHash != -1) {
                link = link.substring(0, posOfHash);
            }
            if ((pM = protocolP.matcher(link)).find()) {
                if (!pM.group().equalsIgnoreCase("http://")) continue;
                result.add(link.substring(7));
                continue;
            }
            String lowCaLink = link.toLowerCase();
            if (lowCaLink.contains("javascript:") || lowCaLink.contains("mailto:") || link.length() <= 3) continue;
            link = URLUtils.makeAbsolute(link, context);
            result.add(link);
        }
        return result;
    }

    public static String removeProtocol(String url) {
        Matcher m = protocolP.matcher(url);
        url = m.replaceFirst("");
        return url;
    }

    public static String getProtocol(String url) {
        Matcher m = protocolP.matcher(url);
        if (m.find()) {
            String result = m.group().toLowerCase();
            return result.substring(0, result.length() - 3);
        }
        return "http";
    }

    public static boolean isPossibleUrl1(String input) {
        return input.toLowerCase().matches("[a-z]+\\.(com|be|ly|org|net|nl)");
    }

    public static boolean isPossibleUrl2(String input) {
        return input.toLowerCase().matches("http://(\\w+\\.)+\\w{2,3}[^ ]*");
    }
}

