/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.util;

import be.bagofwords.text.ExtendedString;
import be.bagofwords.text.HTMLEntities;
import be.bagofwords.text.MappedText;
import be.bagofwords.text.Match;
import be.bagofwords.text.SimpleString;
import be.bagofwords.text.WordIterator;
import be.bagofwords.util.Direction;
import be.bagofwords.util.Pair;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    public static final int NUM_OF_PADDED_SPACES = 1;
    static final char[] quotes = new char[]{'\"', '\'', '\u2018', '\u2019', '\u201c', '\u201d'};
    private static final CharArrayList characterMapping = new CharArrayList();
    private static final Map<Character, Character> escapeFileNameMapping = new HashMap<Character, Character>();
    private static final Map<Character, Character> escapeTab;
    private static final Map<Character, Character> escapePath;
    private static final Map<Character, Character> escapeNewLine;
    private static final String[] topLevelDomains;
    private static final List<String> certainErrorRegex;
    private static Pattern namePattern;

    public static void normalizeQuotationMarks(char[] extracted) {
        for (int pos = 0; pos < extracted.length; ++pos) {
            boolean foundQuote = false;
            for (int i = 0; i < quotes.length && !foundQuote; ++i) {
                if (quotes[i] != extracted[pos]) continue;
                foundQuote = true;
                extracted[pos] = 39;
            }
        }
    }

    public static boolean isASCIIVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' || c == 'y';
    }

    public static boolean isASCIIConsonant(char c) {
        return c == 'b' || c == 'c' || c == 'd' || c == 'f' || c == 'g' || c == 'h' || c == 'j' || c == 'k' || c == 'l' || c == 'm' || c == 'n' || c == 'p' || c == 'q' || c == 'r' || c == 's' || c == 't' || c == 'v' || c == 'w' || c == 'x' || c == 'z';
    }

    public static String removeAccentsSlow(String str) {
        if (str.contains("\u00d8") || str.contains("\u00f8")) {
            str = str.replaceAll("\u00f8", "o").replaceAll("\u00d8", "O");
        }
        String nfdNormalizedString = Normalizer.normalize(str, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(nfdNormalizedString).replaceAll("");
    }

    public static void removeHTML(MappedText mappedText) {
        StringUtils.replaceScripts(mappedText);
        StringUtils.replaceAll("<style[^<]+</style>", "", mappedText);
        StringUtils.replaceAll("<br[^>]*>", "\n", mappedText);
        StringUtils.replaceAll("</?p[^>]*>", "\n", mappedText);
        StringUtils.replaceAll("</?div[^>]*>", "\n", mappedText);
        StringUtils.replaceAll("</?h[1234][^>]*>", "\n", mappedText);
        StringUtils.replaceAll("<[^>]*>", "", mappedText);
        StringUtils.replaceHTMLEntities(mappedText);
    }

    private static void replaceScripts(MappedText mappedText) {
        Pattern pattern1 = Pattern.compile("<script[^>]*>");
        Pattern pattern2 = Pattern.compile("</script");
        Matcher matcher1 = pattern1.matcher(mappedText.getText());
        Matcher matcher2 = pattern2.matcher(mappedText.getText());
        ArrayList<Pair<Integer, Integer>> matches1 = new ArrayList<Pair<Integer, Integer>>();
        ArrayList<Pair<Integer, Integer>> matches2 = new ArrayList<Pair<Integer, Integer>>();
        while (matcher1.find()) {
            matches1.add(new Pair<Integer, Integer>(matcher1.start(), matcher1.end()));
        }
        while (matcher2.find()) {
            matches2.add(new Pair<Integer, Integer>(matcher2.start(), matcher2.end()));
        }
        if (matches1.size() != matches2.size()) {
            throw new IllegalArgumentException("Could not parse this file!");
        }
        ArrayList<Pair<Integer, Integer>> matches = new ArrayList<Pair<Integer, Integer>>();
        for (int i = 0; i < matches1.size(); ++i) {
            matches.add(new Pair(((Pair)matches1.get(i)).getSecond(), ((Pair)matches2.get(i)).getFirst()));
        }
        StringUtils.replaceMatches(matches, "", mappedText);
    }

    public static void replaceMatches(List<Match> matches, MappedText mappedText) {
        Collections.sort(matches);
        StringUtils.checkForOverlapping(matches);
        int newLength = StringUtils.computeNewLength(mappedText, matches);
        char[] newText = new char[newLength];
        int[] newMapping = new int[newLength];
        int positionInOrig = 0;
        int positionDiff = 0;
        for (Match match : matches) {
            if (positionInOrig > match.getStart()) {
                throw new RuntimeException("Something went wrong while replacing matches in text.");
            }
            String replacement = match.getReplacement();
            while (positionInOrig < match.getStart()) {
                newText[positionInOrig + positionDiff] = mappedText.getTextArray()[positionInOrig];
                newMapping[positionInOrig + positionDiff] = mappedText.getMappingToOrig()[positionInOrig];
                ++positionInOrig;
            }
            Pair<Integer, Integer> oldMatch = match.keepWordMapping() ? mappedText.getMappingToOrig(match.getStart(), match.getEnd()) : null;
            for (int i = 0; i < replacement.length(); ++i) {
                newText[positionInOrig + positionDiff + i] = replacement.charAt(i);
                int newCharMapping = oldMatch != null && i == 0 ? oldMatch.getFirst() : (oldMatch != null && i == replacement.length() - 1 ? oldMatch.getSecond() - 1 : -1);
                newMapping[positionInOrig + positionDiff + i] = newCharMapping;
            }
            positionDiff += replacement.length() - (match.getEnd() - match.getStart());
            positionInOrig += match.getEnd() - match.getStart();
        }
        while (positionInOrig < mappedText.getTextArray().length) {
            newText[positionInOrig + positionDiff] = mappedText.getTextArray()[positionInOrig];
            newMapping[positionInOrig + positionDiff] = mappedText.getMappingToOrig()[positionInOrig];
            ++positionInOrig;
        }
        mappedText.setText(newText);
        mappedText.setMappingToOrig(newMapping);
    }

    private static int computeNewLength(MappedText mappedText, List<Match> matches) {
        int length = mappedText.getText().length();
        for (Match match : matches) {
            length -= match.getEnd() - match.getStart();
            length += match.getReplacement().length();
        }
        return length;
    }

    private static void checkForOverlapping(List<Match> sortedMatches) {
        for (int i = 0; i < sortedMatches.size(); ++i) {
            Match first = sortedMatches.get(i);
            for (int j = i + 1; j < sortedMatches.size(); ++j) {
                Match second = sortedMatches.get(j);
                if (second.getStart() >= first.getEnd()) continue;
                throw new RuntimeException("Found overlapping matches " + first + " " + second);
            }
        }
    }

    public static void replaceMatches(List<Pair<Integer, Integer>> matches, String repl, MappedText mappedText) {
        ArrayList<Match> replacements = new ArrayList<Match>();
        for (Pair<Integer, Integer> match : matches) {
            replacements.add(new Match(match.getFirst(), match.getSecond(), repl));
        }
        StringUtils.replaceMatches(replacements, mappedText);
    }

    private static void replaceHTMLEntities(MappedText mappedText) {
        String text = mappedText.getText();
        Matcher m = HTMLEntities.htmlEntityPattern.matcher(text);
        ArrayList<Match> matches = new ArrayList<Match>();
        block0: while (m.find()) {
            String entity = text.substring(m.start(), m.end());
            if (entity.matches("&#\\d{1,6};")) {
                char to = (char)Integer.parseInt(entity.substring(2, entity.length() - 1));
                matches.add(new Match(m.start(), m.end(), "" + to));
                continue;
            }
            for (String key : HTMLEntities.entityMapping.keySet()) {
                if (!entity.equals(key)) continue;
                char to = HTMLEntities.entityMapping.get(key).charValue();
                matches.add(new Match(m.start(), m.end(), "" + to));
                continue block0;
            }
        }
        StringUtils.replaceMatches(matches, mappedText);
    }

    public static String replaceHTMLEntities(String line) {
        Matcher m = HTMLEntities.htmlEntityPattern.matcher(line);
        ArrayList<Pair<Integer, Integer>> matches = new ArrayList<Pair<Integer, Integer>>();
        ArrayList<String> replacements = new ArrayList<String>();
        block0: while (m.find()) {
            String entity = line.substring(m.start(), m.end());
            if (entity.matches("&#\\d{1,6};")) {
                char to = (char)Integer.parseInt(entity.substring(2, entity.length() - 1));
                matches.add(new Pair<Integer, Integer>(m.start(), m.end()));
                replacements.add("" + to);
                continue;
            }
            for (String key : HTMLEntities.entityMapping.keySet()) {
                if (!entity.equals(key)) continue;
                char to = HTMLEntities.entityMapping.get(key).charValue();
                matches.add(new Pair<Integer, Integer>(m.start(), m.end()));
                replacements.add("" + to);
                continue block0;
            }
        }
        StringBuilder result = new StringBuilder();
        int prevEnd = 0;
        for (int i = 0; i < matches.size(); ++i) {
            Pair match = (Pair)matches.get(i);
            result.append(line.substring(prevEnd, (Integer)match.getFirst()));
            result.append((String)replacements.get(i));
            prevEnd = (Integer)match.getSecond();
        }
        result.append(line.substring(prevEnd));
        return result.toString();
    }

    public static void convertToLowerCase(char[] inputFile) {
        for (int i = 0; i < inputFile.length; ++i) {
            inputFile[i] = Character.toLowerCase(inputFile[i]);
        }
    }

    public static void split(MappedText mappedText, int start, int end) {
        char[] newText = new char[end - start];
        int[] newMapping = new int[end - start];
        for (int i = start; i < end; ++i) {
            newText[i - start] = mappedText.getTextArray()[i];
            newMapping[i - start] = mappedText.getMappingToOrig()[i];
        }
        mappedText.setText(newText);
        mappedText.setMappingToOrig(newMapping);
    }

    public static void replaceString(int start, int end, String repl, MappedText mappedText) {
        StringUtils.replaceMatches(Arrays.asList(new Match(start, end, repl)), mappedText);
    }

    public static void replaceAll(String regex, String repl, MappedText mappedText) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(mappedText.getText());
        ArrayList<Pair<Integer, Integer>> matches = new ArrayList<Pair<Integer, Integer>>();
        while (matcher.find()) {
            matches.add(new Pair<Integer, Integer>(matcher.start(), matcher.end()));
        }
        StringUtils.replaceMatches(matches, repl, mappedText);
    }

    public static byte[] convert(String word) {
        int ind;
        byte[] result = word.getBytes();
        for (ind = result.length; ind > 0 && result[ind - 1] == 0; --ind) {
        }
        if (ind < result.length) {
            result = Arrays.copyOf(result, ind);
        }
        return result;
    }

    public static byte[] convert(char[] word) {
        return StringUtils.convert(new String(word));
    }

    public static String convert(byte[] data) {
        return StringUtils.convert(data, 0, data.length);
    }

    public static String convert(byte[] data, int offset, int length) {
        Charset ch = Charset.forName("utf-8");
        ByteBuffer buff = ByteBuffer.wrap(data, offset, length);
        return ch.decode(buff).toString();
    }

    public static String convert(ByteBuffer value) {
        Charset ch = Charset.forName("utf-8");
        return ch.decode(value).toString();
    }

    public static String prepareWordForIndex(String word) {
        word = StringUtils.reduceCharacterDiversityLevel2(word);
        return new String(StringUtils.addSpaces(word));
    }

    private static char[] addSpaces(CharSequence word) {
        char[] newS = new char[word.length() + 2];
        for (int i = 0; i < newS.length; ++i) {
            newS[i] = i < 1 || i >= word.length() + 1 ? 32 : word.charAt(i - 1);
        }
        return newS;
    }

    public static String removeAccents(char[] newS) {
        for (int i = 0; i < newS.length; ++i) {
            char orig = newS[i];
            newS[i] = StringUtils.removeAccent(orig);
        }
        return new String(newS);
    }

    public static char removeAccent(char orig) {
        boolean nonAscii;
        boolean bl = nonAscii = orig < '\u0000' || orig > '\u0080';
        if (nonAscii) {
            return StringUtils.getMappedCharacter(orig);
        }
        return orig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char getMappedCharacter(char orig) {
        char mapping = '\uffff';
        if (orig < characterMapping.size()) {
            mapping = characterMapping.get((int)orig).charValue();
        }
        if (mapping == '\uffff') {
            CharArrayList charArrayList = characterMapping;
            synchronized (charArrayList) {
                String s = new String(new char[]{orig});
                String mappedS = StringUtils.removeAccentsSlow(s);
                mapping = mappedS.isEmpty() ? orig : mappedS.charAt(0);
                if (characterMapping.size() <= orig) {
                    for (int i = characterMapping.size(); i <= orig; ++i) {
                        characterMapping.add('\uffff');
                    }
                }
                characterMapping.set((int)orig, mapping);
            }
        }
        return mapping;
    }

    public static String removeAccents(String origWord) {
        return StringUtils.removeAccents(origWord.toCharArray());
    }

    public static String removeIncorrectDash(String origWord) {
        return origWord.replace('\u2013', '-');
    }

    public static int getPartition(String word, int numOfPartitions) {
        if (word.isEmpty()) {
            return 0;
        }
        return StringUtils.getPartition(word.charAt(0), numOfPartitions);
    }

    public static int getPartition(char firstLetter, int numOfPartitions) {
        char firstLetterLowerCase = Character.toLowerCase(firstLetter);
        if (firstLetterLowerCase < 'a' || firstLetterLowerCase > 'z') {
            return 0;
        }
        return (firstLetterLowerCase - 97) * numOfPartitions / 26;
    }

    public static boolean crossesParagraphBoundaries(String ngram) {
        for (int i = 0; i < ngram.length(); ++i) {
            char c = ngram.charAt(i);
            if (c != '\r' && c != '\n' && c != '\t') continue;
            return true;
        }
        return false;
    }

    public static String escapeFileName(String inputString) {
        return StringUtils.escapeString(inputString, '_', escapeFileNameMapping);
    }

    public static String unescapeFileName(String inputString) {
        return StringUtils.unescapeString(inputString, '_', escapeFileNameMapping);
    }

    private static String escapeString(String inputString, char escapeChar, Map<Character, Character> mapping) {
        StringBuilder result = new StringBuilder();
        int last = 0;
        for (int pos = 0; pos < inputString.length(); ++pos) {
            char curr = inputString.charAt(pos);
            Character replacement = curr == escapeChar ? Character.valueOf(escapeChar) : mapping.get(Character.valueOf(curr));
            if (replacement == null) continue;
            result.append(inputString.substring(last, pos));
            result.append(escapeChar);
            result.append(replacement);
            last = pos + 1;
        }
        result.append(inputString.substring(last));
        String finalResult = result.toString();
        return finalResult;
    }

    private static String unescapeString(String inputString, char escapeChar, Map<Character, Character> mapping) {
        StringBuilder result = new StringBuilder();
        int last = 0;
        for (int pos = 0; pos < inputString.length(); ++pos) {
            char curr = inputString.charAt(pos);
            if (curr != escapeChar) continue;
            if (pos + 1 >= inputString.length()) {
                throw new RuntimeException("Incorrect string " + inputString + " for escape char " + escapeChar);
            }
            char next = inputString.charAt(pos + 1);
            Character orig = StringUtils.findOrig(escapeChar, mapping, next);
            if (orig == null) {
                throw new RuntimeException("Incorrect string " + inputString + " for escape char " + escapeChar);
            }
            result.append(inputString.substring(last, pos));
            result.append(orig);
            last = ++pos + 1;
        }
        result.append(inputString.substring(last));
        return result.toString();
    }

    private static Character findOrig(char escapeChar, Map<Character, Character> mapping, char next) {
        if (next == escapeChar) {
            return Character.valueOf(escapeChar);
        }
        for (Map.Entry<Character, Character> entry : mapping.entrySet()) {
            if (entry.getValue().charValue() != next) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String escapeTab(String inputString) {
        return StringUtils.escapeString(inputString, '_', escapeTab);
    }

    public static String unescapeTab(String inputString) {
        return StringUtils.unescapeString(inputString, '_', escapeTab);
    }

    public static String unescapePathName(String inputString) {
        return StringUtils.unescapeString(inputString, '_', escapePath);
    }

    public static String escapeNewLine(String inputString) {
        return StringUtils.escapeString(inputString, '\u00a7', escapeNewLine);
    }

    public static String unescapeNewLine(String inputString) {
        return StringUtils.unescapeString(inputString, '\u00a7', escapeNewLine);
    }

    public static String escapePathName(String inputString) {
        return StringUtils.escapeString(inputString, '_', escapePath);
    }

    public static String removeRedundantWhiteSpace(String origString) {
        String newString1 = origString;
        String newString2 = newString1.replaceAll("\\s", " ");
        while (!newString2.equals(newString1)) {
            newString1 = newString2;
            newString2 = newString1.replaceAll("  ", " ");
        }
        return newString2.trim();
    }

    public static boolean isPossibleName(String ngram) {
        return namePattern.matcher(ngram).matches();
    }

    public static String reduceCharacterDiversityLevel1(SimpleString word) {
        return StringUtils.reduceCharacterDiversityLevel1(word.getS());
    }

    public static String reduceCharacterDiversityLevel1(String word) {
        char[] data = word.toCharArray();
        return StringUtils.reduceCharacterDiversityLevel1(data);
    }

    public static String reduceCharacterDiversityLevel1(char[] text) {
        StringUtils.convertToLowerCase(text);
        return StringUtils.reduceCharacterDiversityLevel0(text);
    }

    public static String reduceCharacterDiversityLevel0(String word) {
        return StringUtils.reduceCharacterDiversityLevel0(word.toCharArray());
    }

    public static String reduceCharacterDiversityLevel0(char[] word) {
        StringUtils.replaceDigits(word);
        return new String(word);
    }

    public static String reduceCharacterDiversityLevel2(String word) {
        return StringUtils.removeAccents(StringUtils.reduceCharacterDiversityLevel1(word));
    }

    public static String reduceCharacterDiversityLevel2(SimpleString word) {
        return StringUtils.reduceCharacterDiversityLevel2(word.getS());
    }

    public static String reduceCharacterDiversityLevel3(String word) {
        return StringUtils.toVownNonVowl(StringUtils.reduceCharacterDiversityLevel2(word));
    }

    public static String reduceCharacterDiversityLevel(int level, String text) {
        switch (level) {
            case 0: {
                return StringUtils.reduceCharacterDiversityLevel0(text);
            }
            case 1: {
                return StringUtils.reduceCharacterDiversityLevel1(text);
            }
            case 2: {
                return StringUtils.reduceCharacterDiversityLevel2(text);
            }
            case 3: {
                return StringUtils.reduceCharacterDiversityLevel3(text);
            }
        }
        throw new RuntimeException("Unknown level " + level);
    }

    private static String toVownNonVowl(String s) {
        char[] result = new char[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            result[i] = StringUtils.isASCIIVowel(result[i]) ? 118 : (StringUtils.isASCIIConsonant(result[i]) ? 99 : (result[i] == ' ' ? 32 : 111));
        }
        return new String(result);
    }

    private static void replaceDigits(char[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (!Character.isDigit(data[i])) continue;
            data[i] = 48;
        }
    }

    public static String urlEncode(String input) {
        try {
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String urlDecode(String input) {
        try {
            return URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean mightBeUrlOrEmailOrHashTag(String fullString) {
        if ((fullString = fullString.toLowerCase()).contains("@")) {
            return true;
        }
        if (fullString.contains("#")) {
            return true;
        }
        if (!fullString.contains(".")) {
            return false;
        }
        if (fullString.contains("/")) {
            return true;
        }
        if (fullString.contains("#")) {
            return true;
        }
        if (fullString.contains("www")) {
            return true;
        }
        for (String topLevelDomain : topLevelDomains) {
            if (!fullString.matches(".*\\." + topLevelDomain + "$") && !fullString.matches(".*\\." + topLevelDomain + "\\W.*")) continue;
            return true;
        }
        return false;
    }

    public static List<SimpleString> splitInWords(String text, Set<String> wordsWithPunct) {
        ArrayList<SimpleString> result = new ArrayList<SimpleString>();
        WordIterator wordIterator = new WordIterator(text, wordsWithPunct);
        while (wordIterator.hasNext()) {
            result.add(wordIterator.next());
        }
        return result;
    }

    public static String createStringContext(SimpleString ex, int length) {
        String bf = ex.getOrigText().substring(Math.max(0, ex.getStart() - length), ex.getStart());
        String er = "**" + ex.getOrigText().substring(ex.getStart(), ex.getEnd()) + "**";
        String af = ex.getOrigText().substring(ex.getEnd(), Math.min(ex.getOrigText().length(), ex.getEnd() + length));
        String result = bf + er + af;
        result = result.replaceAll("\n", " ").replaceAll("\t", " ");
        while (result.contains("  ")) {
            result = result.replaceAll("  ", " ");
        }
        return result;
    }

    public static ExtendedString getPrevWord(SimpleString err, Set<String> wordsWithPunctuation) {
        return WordIterator.findWord(err.getOrigText().toCharArray(), err.getStart(), Direction.Left, wordsWithPunctuation);
    }

    public static ExtendedString getNextWord(SimpleString err, Set<String> wordsWithPunctuation) {
        return WordIterator.findWord(err.getOrigText().toCharArray(), err.getEnd(), Direction.Right, wordsWithPunctuation);
    }

    public static String getLastNgram(SimpleString example, int length) {
        String tagS = example.getS();
        while (tagS.length() < length) {
            tagS = tagS + " ";
        }
        return tagS.substring(tagS.length() - length);
    }

    public static String getFirstNgram(SimpleString example, int length) {
        String tagS = example.getS();
        while (tagS.length() < length) {
            tagS = " " + tagS;
        }
        return tagS.substring(0, length);
    }

    public static boolean isCapital(char letter) {
        return Character.isUpperCase(StringUtils.removeAccent(letter));
    }

    public static String getSuffix(String word, int length, int reductionLevel) {
        String suffix = StringUtils.reduceCharacterDiversityLevel(reductionLevel, word);
        return suffix.substring(Math.max(0, suffix.length() - length));
    }

    public static String getSuffix(SimpleString word, int length, int reductionLevel) {
        return StringUtils.getSuffix(word.getS(), length, reductionLevel);
    }

    static {
        escapeFileNameMapping.put(Character.valueOf('/'), Character.valueOf('+'));
        escapeFileNameMapping.put(Character.valueOf('\\'), Character.valueOf('-'));
        escapeTab = new HashMap<Character, Character>();
        escapeTab.put(Character.valueOf('\t'), Character.valueOf(' '));
        escapePath = new HashMap<Character, Character>();
        escapePath.put(Character.valueOf('/'), Character.valueOf('-'));
        escapePath.put(Character.valueOf('\r'), Character.valueOf('+'));
        escapePath.put(Character.valueOf('\n'), Character.valueOf('$'));
        escapePath.put(Character.valueOf('\t'), Character.valueOf('\u00a7'));
        escapePath.put(Character.valueOf(' '), Character.valueOf('.'));
        escapeNewLine = new HashMap<Character, Character>();
        escapeNewLine.put(Character.valueOf('\r'), Character.valueOf('r'));
        escapeNewLine.put(Character.valueOf('\n'), Character.valueOf('n'));
        topLevelDomains = new String[]{"com", "co.uk", "net", "org", "nl", "be", "me", "nu"};
        certainErrorRegex = Arrays.asList(".*\\d+[A-Za-z]{3,}.*", ".*\\d+\\.[A-Za-z]{3,}.*");
        namePattern = Pattern.compile("([^a-zA-Z]*[A-Z][a-z]*[^a-zA-Z]*)+");
    }
}

