/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.util;

import be.bagofwords.application.CloseableComponent;
import be.bagofwords.ui.UI;
import be.bagofwords.util.Utils;

public abstract class SafeThread
extends Thread
implements CloseableComponent {
    private boolean terminateRequested;
    private boolean finished;

    public SafeThread(String name, boolean isDaemonThread) {
        super(name);
        super.setDaemon(isDaemonThread);
        this.finished = false;
        this.terminateRequested = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.runInt();
        }
        catch (Throwable t) {
            UI.writeError("Received exception while running " + this.getName(), t);
        }
        finally {
            this.finished = true;
        }
    }

    public void requestTermination() {
        this.terminateRequested = true;
        this.doTerminate();
    }

    protected void doTerminate() {
    }

    public boolean isTerminateRequested() {
        return this.terminateRequested;
    }

    public boolean isFinished() {
        return this.finished;
    }

    protected abstract void runInt() throws Exception;

    public void waitForFinish(long timeToWait) {
        long start = System.currentTimeMillis();
        while (!(this.isFinished() || timeToWait != -1L && System.currentTimeMillis() - start >= timeToWait)) {
            Utils.threadSleep(100L);
        }
    }

    public void waitForFinish() {
        this.waitForFinish(-1L);
    }

    @Override
    public void terminate() {
        this.requestTermination();
        this.waitForFinish();
    }
}

