/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.text;

import be.bagofwords.text.SimpleString;
import be.bagofwords.util.HashUtils;
import java.util.Arrays;

public class ExtendedString
implements CharSequence,
Comparable<ExtendedString>,
SimpleString {
    public final char[] data;
    public int start;
    public int end;

    public ExtendedString(char[] data, int start, int end) {
        this.data = data;
        this.start = start;
        this.end = end;
    }

    public ExtendedString(char[] data) {
        this(data, 0, data.length);
    }

    public ExtendedString(String s) {
        this(s.toCharArray());
    }

    public int hashCode() {
        return HashUtils.integerHashCode(this.getS());
    }

    public ExtendedString clone() {
        return new ExtendedString(this.data, this.start, this.end);
    }

    public boolean equals(Object obj) {
        CharSequence s;
        char[] comp = null;
        int compStart = -1;
        int compEnd = -1;
        if (obj instanceof ExtendedString) {
            s = (ExtendedString)obj;
            comp = ((ExtendedString)s).data;
            compStart = ((ExtendedString)s).start;
            compEnd = ((ExtendedString)s).end;
        } else if (obj instanceof String) {
            s = (String)obj;
            comp = ((String)s).toCharArray();
            compStart = 0;
            compEnd = comp.length;
        }
        if (comp != null) {
            boolean same = compEnd - compStart == this.end - this.start;
            for (int i = this.start; same && i < this.end; same &= this.data[i] == comp[i - this.start + compStart], ++i) {
            }
            return same;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getS();
    }

    @Override
    public char charAt(int index) {
        return this.data[this.start + index];
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public ExtendedString subSequence(int start, int end) {
        return new ExtendedString(this.data, this.start + start, this.start + end);
    }

    @Override
    public int compareTo(ExtendedString o) {
        int length = Math.min(this.length(), o.length());
        for (int i = 0; i < length; ++i) {
            if (this.data[this.start + i] < o.data[o.start + i]) {
                return -1;
            }
            if (this.data[this.start + i] <= o.data[o.start + i]) continue;
            return 1;
        }
        if (this.length() < o.length()) {
            return -1;
        }
        if (o.length() < this.length()) {
            return 1;
        }
        return 0;
    }

    public ExtendedString toLowerCase() {
        char[] newD = Arrays.copyOfRange(this.data, this.start, this.end);
        for (int i = 0; i < newD.length; ++i) {
            if (!Character.isUpperCase(newD[i])) continue;
            newD[i] = Character.toLowerCase(newD[i]);
        }
        return new ExtendedString(newD);
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public String getS() {
        return new String(this.data, this.start, this.end - this.start);
    }

    @Override
    public String getOrigText() {
        return new String(this.data);
    }

    @Override
    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }
}

