/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.iterator;

import be.bagofwords.iterator.DataIterable;
import be.bagofwords.ui.UI;
import java.util.Iterator;

public class MultipleSwipesIterator<T>
implements Iterator<T> {
    private final DataIterable<T> iterable;
    private Iterator<T> currIt;
    private T currObj;
    private final int numOfSwipes;
    private int currentSwipe;

    public MultipleSwipesIterator(DataIterable<T> iterable, int numOfSwipes) {
        this.iterable = iterable;
        this.numOfSwipes = numOfSwipes;
        this.currentSwipe = 0;
        this.currIt = iterable.iterator();
        this.currObj = this.findNext();
    }

    private T findNext() {
        while (this.currentSwipe < this.numOfSwipes) {
            if (this.currIt.hasNext()) {
                return this.currIt.next();
            }
            UI.write("Finished swipe " + this.currentSwipe + " of " + this.numOfSwipes);
            ++this.currentSwipe;
            if (this.currentSwipe >= this.numOfSwipes) continue;
            this.currIt = this.iterable.iterator();
        }
        return null;
    }

    public int getCurrentSwipe() {
        return this.currentSwipe;
    }

    @Override
    public boolean hasNext() {
        return this.currObj != null;
    }

    @Override
    public T next() {
        T result = this.currObj;
        this.currObj = this.findNext();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

