/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.iterator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableInt;

public class IteratorOfIterables<T>
implements Iterator<T> {
    private Iterator<Iterable<T>> intIterator;
    private Iterator<T> iterator;

    public IteratorOfIterables(Iterator<Iterable<T>> intIterator) {
        this.initialize(intIterator);
    }

    public IteratorOfIterables(Iterable<T> ... iterables) {
        this(Arrays.asList(iterables));
    }

    public IteratorOfIterables(final List<Iterable<T>> iterables) {
        final MutableInt ind = new MutableInt(0);
        this.initialize(new Iterator<Iterable<T>>(){

            @Override
            public boolean hasNext() {
                return ind.intValue() < iterables.size();
            }

            @Override
            public Iterable<T> next() {
                Iterable next = (Iterable)iterables.get(ind.intValue());
                ind.increment();
                return next;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Not possible with multiple iterables...");
            }
        });
    }

    private void initialize(Iterator<Iterable<T>> intIterator) {
        this.intIterator = intIterator;
        this.findNextIterator();
    }

    private void findNextIterator() {
        Iterator<T> nextIterator = null;
        while ((nextIterator == null || !nextIterator.hasNext()) && this.intIterator.hasNext()) {
            nextIterator = this.intIterator.next().iterator();
        }
        this.iterator = nextIterator != null && nextIterator.hasNext() ? nextIterator : null;
    }

    @Override
    public boolean hasNext() {
        return this.iterator != null && this.iterator.hasNext();
    }

    @Override
    public T next() {
        T nextVal = this.iterator.next();
        if (!this.iterator.hasNext()) {
            this.findNextIterator();
        }
        return nextVal;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

