/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.cache;

import be.bagofwords.application.CloseableComponent;
import be.bagofwords.application.annotations.BowComponent;
import be.bagofwords.application.memory.MemoryGobbler;
import be.bagofwords.application.memory.MemoryManager;
import be.bagofwords.application.status.StatusViewable;
import be.bagofwords.cache.Cache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@BowComponent
public class CachesManager
implements MemoryGobbler,
StatusViewable,
CloseableComponent {
    private List<Cache> caches = new ArrayList<Cache>();
    private MemoryManager memoryManager;

    @Autowired
    public CachesManager(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
        this.memoryManager.registerMemoryGobbler(this);
    }

    @Override
    public void freeMemory() {
        for (Cache cache : this.caches) {
            if (cache.isWriteBuffer()) continue;
            cache.moveCachedObjectsToOld();
        }
    }

    @Override
    public String getMemoryUsage() {
        return "caches read=" + this.sizeOfAllReadCaches() + " write=" + this.sizeOfAllWriteBuffers();
    }

    private long sizeOfAllReadCaches() {
        long result = 0L;
        for (Cache cache : this.caches) {
            if (cache.isWriteBuffer()) continue;
            result += cache.completeSize();
        }
        return result;
    }

    private long sizeOfAllWriteBuffers() {
        long result = 0L;
        for (Cache cache : this.caches) {
            if (!cache.isWriteBuffer()) continue;
            result += cache.size();
        }
        return result;
    }

    public synchronized <T> Cache<T> createNewCache(boolean isWriteBuffer, String name, Class<? extends T> objectClass) {
        Cache<? extends T> newCache = new Cache<T>(isWriteBuffer, name, objectClass);
        this.caches.add(newCache);
        return newCache;
    }

    public List<Cache> getAllCaches() {
        return this.caches;
    }

    @Override
    public void printHtmlStatus(StringBuilder sb) {
        sb.append("<h1>Caches</h1>");
        ArrayList<Cache> sortedCaches = new ArrayList<Cache>(this.caches);
        Collections.sort(sortedCaches, new Comparator<Cache>(){

            @Override
            public int compare(Cache o1, Cache o2) {
                return -Double.compare(o1.size(), o2.size());
            }
        });
        for (Cache cache : sortedCaches) {
            double hitRatio = cache.getNumberOfHits() == 0L ? 0.0 : (double)cache.getNumberOfHits() / (double)cache.getNumberOfFetches();
            sb.append(cache.getName() + " size=" + cache.size() + " fetches=" + cache.getNumberOfFetches() + " hits=" + cache.getNumberOfHits() + " hitRatio=" + hitRatio);
            sb.append("<br>");
        }
    }

    @Override
    public synchronized void terminate() {
    }
}

