/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.application.status.perf;

import be.bagofwords.application.status.perf.Trace;
import be.bagofwords.counts.Counter;
import be.bagofwords.util.NumUtils;
import java.util.ArrayList;
import java.util.List;

public class ThreadSamplesPrinter {
    private static final double MIN_FRACTION = 0.001;

    public static void printTopTraces(StringBuilder result, Counter<Trace> traces) {
        ArrayList<Trace> sortedTraces = new ArrayList<Trace>(traces.sortedKeys());
        double total = 0.0;
        for (Trace trace : sortedTraces) {
            if (trace.getParent() != null) continue;
            total += (double)traces.get(trace);
        }
        for (int i = 0; i < sortedTraces.size(); ++i) {
            Trace parentTrace = (Trace)sortedTraces.get(i);
            if (parentTrace.getParent() != null) continue;
            ThreadSamplesPrinter.printTrace(0, "", result, parentTrace, traces, total, sortedTraces, false);
        }
    }

    private static void printTrace(int level, String combinedIndentation, StringBuilder result, Trace parentTrace, Counter<Trace> traces, double total, List<Trace> sortedTraces, boolean printHorizontalLine) {
        double fraction = (double)traces.get(parentTrace) / total;
        if (fraction > 0.001) {
            String indentation = combinedIndentation + (printHorizontalLine ? "\\" : " ");
            int numOfChildren = ThreadSamplesPrinter.countNumberOfChildren(parentTrace, traces, sortedTraces, total);
            result.append(indentation + NumUtils.makeNicePercent(fraction) + "% " + parentTrace.getLine() + "\n");
            int numOfChildrenPrinted = 0;
            for (Trace subtrace : sortedTraces) {
                if (subtrace.getParent() == null || !subtrace.getParent().equals(parentTrace)) continue;
                char trackingLine = level % 2 == 0 ? (char)'|' : '!';
                ThreadSamplesPrinter.printTrace(level + 1, combinedIndentation + " " + (numOfChildrenPrinted < numOfChildren - 1 ? " " + trackingLine : "  "), result, subtrace, traces, total, sortedTraces, numOfChildren > 0);
                ++numOfChildrenPrinted;
            }
        }
    }

    private static int countNumberOfChildren(Trace parentTrace, Counter<Trace> traces, List<Trace> sortedTraces, double total) {
        int numOfChildren = 0;
        for (Trace subtrace : sortedTraces) {
            double fraction;
            if (subtrace.getParent() == null || !subtrace.getParent().equals(parentTrace) || !((fraction = (double)traces.get(subtrace) / total) > 0.001)) continue;
            ++numOfChildren;
        }
        return numOfChildren;
    }
}

