/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.application.status.perf;

import be.bagofwords.application.ApplicationContextFactory;
import be.bagofwords.application.CloseableComponent;
import be.bagofwords.application.EnvironmentProperties;
import be.bagofwords.application.annotations.EagerBowComponent;
import be.bagofwords.application.status.perf.ThreadSamplesPrinter;
import be.bagofwords.application.status.perf.Trace;
import be.bagofwords.counts.Counter;
import be.bagofwords.ui.UI;
import be.bagofwords.util.SafeThread;
import be.bagofwords.web.BaseController;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import spark.Request;
import spark.Response;

@EagerBowComponent
public class ThreadSampleMonitor
extends BaseController
implements CloseableComponent {
    public static final int MAX_NUM_OF_SAMPLES = 10000;
    private final TraceSampler traceSampler;
    private final Counter<Trace> relevantTracesCounter;
    private final Counter<Trace> lessRelevantTracesCounter;
    private boolean saveThreadSamplesToFile;
    private String locationForSavedThreadSamples;
    private String applicationName;

    @Autowired
    public ThreadSampleMonitor(EnvironmentProperties environmentProperties, ApplicationContextFactory applicationContextFactory) {
        this(environmentProperties.saveThreadSamplesToFile(), environmentProperties.getThreadSampleLocation(), applicationContextFactory.getApplicationName());
    }

    public ThreadSampleMonitor(boolean saveThreadSamplesToFile, String locationForSavedThreadSamples, String applicationName) {
        super("/perf");
        this.saveThreadSamplesToFile = saveThreadSamplesToFile;
        this.locationForSavedThreadSamples = locationForSavedThreadSamples;
        this.applicationName = applicationName;
        this.relevantTracesCounter = new Counter();
        this.lessRelevantTracesCounter = new Counter();
        this.traceSampler = new TraceSampler();
        this.traceSampler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized String handleRequest(Request request, Response response) throws Exception {
        StringBuilder result = new StringBuilder();
        Counter<Trace> counter = this.relevantTracesCounter;
        synchronized (counter) {
            Counter<Trace> counter2 = this.lessRelevantTracesCounter;
            synchronized (counter2) {
                result.append("Collected " + this.relevantTracesCounter.getTotal() + " samples.");
                result.append("<h1>Relevant traces</h1><pre>");
                ThreadSamplesPrinter.printTopTraces(result, this.relevantTracesCounter);
                result.append("</pre>");
                result.append("<h1>Other traces</h1><pre>");
                ThreadSamplesPrinter.printTopTraces(result, this.lessRelevantTracesCounter);
                result.append("</pre>");
            }
        }
        return result.toString();
    }

    @Override
    public void terminate() {
        this.traceSampler.terminate();
        if (this.saveThreadSamplesToFile) {
            this.saveThreadSamplesToFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveThreadSamplesToFile() {
        try {
            Counter<Trace> counter = this.relevantTracesCounter;
            synchronized (counter) {
                Counter<Trace> counter2 = this.lessRelevantTracesCounter;
                synchronized (counter2) {
                    File file = new File(this.locationForSavedThreadSamples + "_" + this.applicationName + "_" + System.currentTimeMillis() / 3600000L + ".txt");
                    StringBuilder sb = new StringBuilder();
                    sb.append("Traces for " + this.applicationName + " on " + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm") + "\n\n");
                    sb.append("-- Relevant traces --\n\n");
                    ThreadSamplesPrinter.printTopTraces(sb, this.relevantTracesCounter);
                    sb.append("\n\n-- Less relevant traces --\n\n");
                    ThreadSamplesPrinter.printTopTraces(sb, this.lessRelevantTracesCounter);
                    FileUtils.writeStringToFile((File)file, (String)sb.toString());
                }
            }
        }
        catch (IOException exp) {
            UI.writeError("Failed to save thread samples!", exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSamples() {
        Counter<Trace> counter = this.relevantTracesCounter;
        synchronized (counter) {
            this.relevantTracesCounter.clear();
        }
        counter = this.lessRelevantTracesCounter;
        synchronized (counter) {
            this.lessRelevantTracesCounter.clear();
        }
    }

    public Counter<Trace> getRelevantTracesCounter() {
        return this.relevantTracesCounter;
    }

    public Counter<Trace> getLessRelevantTracesCounter() {
        return this.lessRelevantTracesCounter;
    }

    private class TraceSampler
    extends SafeThread {
        public TraceSampler() {
            super("traceSampler", true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void runInt() throws Exception {
            while (!this.isTerminateRequested()) {
                Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
                for (Thread thread : stackTraces.keySet()) {
                    StackTraceElement[] thisTrace = stackTraces.get(thread);
                    String threadName = thread.getName();
                    if (threadName.equals("traceSampler") || thisTrace.length <= 0) continue;
                    String methodName = thisTrace[0].getMethodName();
                    boolean notRelevantThread = threadName.equals("SparkServerThread") || threadName.equals("Signal Dispatcher") || threadName.equals("Finalizer");
                    notRelevantThread |= threadName.equals("DateCache") || threadName.startsWith("qtp") || threadName.equals("Reference Handler") || threadName.startsWith("HashSessionScavenger");
                    notRelevantThread |= methodName.equals("accept0") || methodName.equals("accept") || methodName.equals("sleep") || methodName.equals("epollWait") || methodName.equals("socketAccept");
                    notRelevantThread |= threadName.equals("ChangedValueListener") && methodName.equals("socketRead0");
                    notRelevantThread |= this.inReadNextActionMethod(threadName, thisTrace);
                    Trace parent = null;
                    for (int i = thisTrace.length - 1; i >= 0; --i) {
                        Counter counter;
                        StackTraceElement element = thisTrace[i];
                        Trace trace = new Trace(element.getClassName() + "." + element.getMethodName() + "(" + element.getFileName() + ":" + element.getLineNumber() + ")", parent);
                        if (notRelevantThread) {
                            counter = ThreadSampleMonitor.this.lessRelevantTracesCounter;
                            synchronized (counter) {
                                ThreadSampleMonitor.this.lessRelevantTracesCounter.inc(trace);
                            }
                        }
                        counter = ThreadSampleMonitor.this.relevantTracesCounter;
                        synchronized (counter) {
                            ThreadSampleMonitor.this.relevantTracesCounter.inc(trace);
                        }
                        parent = trace;
                    }
                }
                Counter counter = ThreadSampleMonitor.this.relevantTracesCounter;
                synchronized (counter) {
                    ThreadSampleMonitor.this.relevantTracesCounter.trim(5000);
                }
                counter = ThreadSampleMonitor.this.lessRelevantTracesCounter;
                synchronized (counter) {
                    ThreadSampleMonitor.this.lessRelevantTracesCounter.trim(5000);
                }
                Thread.sleep(200L);
            }
        }

        private boolean inReadNextActionMethod(String threadName, StackTraceElement[] thisTrace) {
            if (threadName.startsWith("DatabaseServerRequestHandler")) {
                for (StackTraceElement traceElement : thisTrace) {
                    if (!traceElement.getMethodName().equals("readNextAction")) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

