/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.application.status;

import be.bagofwords.application.CloseableComponent;
import be.bagofwords.application.annotations.BowController;
import be.bagofwords.application.status.RegisterUrlsServer;
import be.bagofwords.application.status.RemoteRegisterUrlsServerProperties;
import be.bagofwords.util.Pair;
import be.bagofwords.web.BaseController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import spark.Request;
import spark.Response;

@BowController
public class ListUrlsController
extends BaseController
implements CloseableComponent {
    private final List<Pair<String, String>> urls = new ArrayList<Pair<String, String>>();
    private final RegisterUrlsServer registerUrlsServer;

    @Autowired
    public ListUrlsController(RemoteRegisterUrlsServerProperties properties) {
        super("/paths");
        this.registerUrlsServer = new RegisterUrlsServer(properties.getRegisterUrlServerPort(), this);
        this.registerUrlsServer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String handleRequest(Request request, Response response) throws Exception {
        StringBuilder result = new StringBuilder();
        List<Pair<String, String>> list = this.urls;
        synchronized (list) {
            for (Pair<String, String> url : this.urls) {
                result.append("<a href=\"" + url.getSecond() + "\">" + url.getFirst() + " " + url.getSecond() + "</a><br>");
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerUrl(String name, String url) {
        List<Pair<String, String>> list = this.urls;
        synchronized (list) {
            this.urls.add(0, new Pair<String, String>(name, url));
            while (this.urls.size() > 20) {
                this.urls.remove(this.urls.get(this.urls.size() - 1));
            }
        }
    }

    @Override
    public void terminate() {
        this.registerUrlsServer.requestTermination();
    }
}

