/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util.resource.internal.vfs;

import be.atbash.util.resource.internal.ResourceWalkerException;
import be.atbash.util.resource.internal.vfs.JarInputFile;
import be.atbash.util.resource.internal.vfs.Vfs;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarInputDir
implements Vfs.Dir {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarInputDir.class);
    private URL url;
    private JarInputStream jarInputStream;

    public JarInputDir(URL url) {
        this.url = url;
    }

    @Override
    public String getPath() {
        return this.url.getPath();
    }

    @Override
    public Iterable<Vfs.File> getFiles() {
        ArrayList<Vfs.File> result = new ArrayList<Vfs.File>();
        try {
            this.jarInputStream = new JarInputStream(this.url.openConnection().getInputStream());
        }
        catch (Exception e) {
            throw new ResourceWalkerException("Could not open url connection", e);
        }
        try {
            JarEntry entry = this.jarInputStream.getNextJarEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    result.add(new JarInputFile(entry));
                }
                entry = this.jarInputStream.getNextJarEntry();
            }
        }
        catch (IOException e) {
            throw new ResourceWalkerException("Error in processing content of " + this.url.getPath(), e);
        }
        return result;
    }

    @Override
    public void close() {
        try {
            if (this.jarInputStream != null) {
                this.jarInputStream.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not close InputStream", (Throwable)e);
        }
    }
}

