/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util.resource;

import be.atbash.util.PublicAPI;
import be.atbash.util.StringUtils;
import be.atbash.util.ordered.OrderComparator;
import be.atbash.util.resource.ResourceReader;
import be.atbash.util.resource.internal.ClassPathResourceReader;
import be.atbash.util.resource.internal.FileResourceReader;
import be.atbash.util.resource.internal.URLResourceReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

@PublicAPI
public class ResourceUtil {
    public static final String FILE_PREFIX = "file:";
    public static final String URL_PREFIX = "url:";
    public static final String CLASSPATH_PREFIX = "classpath:";
    private static ResourceUtil INSTANCE;
    private List<ResourceReader> readers = new ArrayList<ResourceReader>();

    private ResourceUtil() {
        this.readers.add(new ClassPathResourceReader());
        this.readers.add(new URLResourceReader());
        this.readers.add(new FileResourceReader());
        for (ResourceReader resourceReader : ServiceLoader.load(ResourceReader.class)) {
            this.readers.add(resourceReader);
        }
        for (ResourceReader resourceReader : ServiceLoader.load(ResourceReader.class, ResourceUtil.class.getClassLoader())) {
            if (this.isReaderFound(resourceReader)) continue;
            this.readers.add(resourceReader);
        }
        Collections.sort(this.readers, new OrderComparator());
    }

    private boolean isReaderFound(ResourceReader resourceReader) {
        boolean result = false;
        for (ResourceReader reader : this.readers) {
            if (!reader.getClass().getName().equals(resourceReader.getClass().getName())) continue;
            result = true;
        }
        return result;
    }

    public boolean isSupported(String resourcePath) {
        return this.isSupported(resourcePath, null);
    }

    public boolean isSupported(String resourcePath, Object context) {
        if (StringUtils.isEmpty(resourcePath)) {
            return false;
        }
        boolean result = false;
        Iterator<ResourceReader> iterator = ResourceUtil.getInstance().readers.iterator();
        while (!result && iterator.hasNext()) {
            result = iterator.next().canRead(resourcePath, context);
        }
        return result;
    }

    public boolean resourceExists(String resourcePath) {
        return this.resourceExists(resourcePath, null);
    }

    public boolean resourceExists(String resourcePath, Object context) {
        boolean result = false;
        Iterator<ResourceReader> iterator = ResourceUtil.getInstance().readers.iterator();
        while (!result && iterator.hasNext()) {
            result = iterator.next().exists(resourcePath, context);
        }
        return result;
    }

    public InputStream getStream(String path) throws IOException {
        return this.getStream(path, null);
    }

    public InputStream getStream(String path, Object context) throws IOException {
        InputStream result = null;
        if (StringUtils.hasText(path)) {
            Iterator<ResourceReader> iterator = ResourceUtil.getInstance().readers.iterator();
            while (result == null && iterator.hasNext()) {
                ResourceReader reader = iterator.next();
                if (!reader.canRead(path, context)) continue;
                result = reader.load(path, context);
            }
        }
        return result;
    }

    public static synchronized ResourceUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ResourceUtil();
        }
        return INSTANCE;
    }
}

