/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util.resource;

import be.atbash.util.PublicAPI;
import be.atbash.util.resource.UrlType;
import be.atbash.util.resource.internal.ResourceWalker;
import be.atbash.util.resource.internal.Store;
import be.atbash.util.resource.internal.vfs.Vfs;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

@PublicAPI
public class ResourceScanner {
    private static ResourceScanner INSTANCE;
    private Store store = new Store();

    private ResourceScanner() {
        new ResourceWalker(this.store).scan();
    }

    public Set<String> getResources(String resourceName) {
        Pattern pattern = Pattern.compile(resourceName);
        return this.getResources(pattern);
    }

    public Set<String> getResources(Pattern pattern) {
        HashSet<String> result = new HashSet<String>();
        for (String key : this.store.keySet()) {
            if (!pattern.matcher(key).matches()) continue;
            result.add(key);
        }
        return result;
    }

    public Set<String> getResourcePaths(String resourceName) {
        Pattern pattern = Pattern.compile(resourceName);
        return this.getResourcePaths(pattern);
    }

    public Set<String> getResourcePaths(Pattern pattern) {
        HashSet<String> result = new HashSet<String>();
        for (String key : this.store.keySet()) {
            if (!pattern.matcher(key).matches()) continue;
            result.addAll(this.store.get(key));
        }
        return result;
    }

    public boolean existsResource(String resourceName) {
        return this.store.keySet().contains(resourceName);
    }

    public boolean isUniqueResource(String resourceName) {
        boolean result = this.existsResource(resourceName);
        if (result) {
            result = this.store.get(resourceName).size() == 1;
        }
        return result;
    }

    public static synchronized ResourceScanner getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ResourceScanner();
        }
        return INSTANCE;
    }

    public static void registerURLType(UrlType urlType) {
        Vfs.registerURLType(urlType);
    }
}

