/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util.codec;

import be.atbash.util.codec.ByteSource;
import be.atbash.util.codec.ByteSourceCreator;
import be.atbash.util.codec.CodecException;
import be.atbash.util.codec.DefaultByteSource;
import java.io.File;
import java.io.InputStream;

public class DefaultByteSourceCreator
implements ByteSourceCreator {
    @Override
    public boolean isCompatible(Object source) {
        return source instanceof byte[] || source instanceof char[] || source instanceof String || source instanceof ByteSource || source instanceof File || source instanceof InputStream;
    }

    @Override
    public ByteSource bytes(Object source) {
        if (source == null) {
            return null;
        }
        if (!this.isCompatible(source)) {
            String msg = String.format("Unable to heuristically acquire bytes for object of type [%s]. If this type is indeed a byte-backed data type, you might want to write your own ByteSourceCreator implementation to extract its bytes explicitly.", source.getClass().getName());
            throw new CodecException(msg);
        }
        if (source instanceof byte[]) {
            return new DefaultByteSource((byte[])source);
        }
        if (source instanceof ByteSource) {
            return (ByteSource)source;
        }
        if (source instanceof char[]) {
            return new DefaultByteSource((char[])source);
        }
        if (source instanceof String) {
            return new DefaultByteSource((String)source);
        }
        if (source instanceof File) {
            return new DefaultByteSource((File)source);
        }
        if (source instanceof InputStream) {
            return new DefaultByteSource((InputStream)source);
        }
        throw new IllegalStateException("Encountered unexpected byte source.  This is a bug - (the isCompatible implementation does not reflect this method's implementation).");
    }
}

