/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util.codec;

import be.atbash.util.base64.Base64Codec;
import be.atbash.util.codec.ByteSource;
import be.atbash.util.codec.CodecSupport;
import be.atbash.util.codec.Hex;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;

public class DefaultByteSource
implements ByteSource {
    private final byte[] bytes;
    private String cachedHex;
    private String cachedBase64;

    public DefaultByteSource(byte[] bytes) {
        this.bytes = bytes;
    }

    public DefaultByteSource(char[] chars) {
        this.bytes = CodecSupport.toBytes(chars);
    }

    public DefaultByteSource(String string) {
        this.bytes = CodecSupport.toBytes(string);
    }

    public DefaultByteSource(File file) {
        this.bytes = new BytesHelper().getBytes(file);
    }

    public DefaultByteSource(InputStream stream) {
        this.bytes = new BytesHelper().getBytes(stream);
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public boolean isEmpty() {
        return this.bytes == null || this.bytes.length == 0;
    }

    @Override
    public String toHex() {
        if (this.cachedHex == null) {
            this.cachedHex = Hex.encodeToString(this.getBytes());
        }
        return this.cachedHex;
    }

    @Override
    public String toBase64() {
        if (this.cachedBase64 == null) {
            this.cachedBase64 = Base64Codec.encodeToString(this.getBytes(), true);
        }
        return this.cachedBase64;
    }

    public String toString() {
        return this.toBase64();
    }

    public int hashCode() {
        if (this.bytes == null || this.bytes.length == 0) {
            return 0;
        }
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ByteSource) {
            ByteSource bs = (ByteSource)o;
            return Arrays.equals(this.getBytes(), bs.getBytes());
        }
        return false;
    }

    private static final class BytesHelper
    extends CodecSupport {
        private BytesHelper() {
        }

        public byte[] getBytes(File file) {
            return this.toBytes(file);
        }

        public byte[] getBytes(InputStream stream) {
            return this.toBytes(stream);
        }
    }
}

