/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util;

import be.atbash.util.exception.AtbashUnexpectedException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public final class TestReflectionUtils {
    private TestReflectionUtils() {
    }

    public static void injectDependencies(Object target, Object ... dependencies) throws IllegalAccessException {
        for (Class<?> targetClass = target.getClass(); targetClass != null && targetClass != Object.class; targetClass = targetClass.getSuperclass()) {
            if (targetClass.getName().contains("$")) {
                targetClass = targetClass.getSuperclass();
            }
            for (Field field : targetClass.getDeclaredFields()) {
                field.setAccessible(true);
                for (Object dependency : dependencies) {
                    if (Modifier.isFinal(field.getModifiers()) || !field.getType().isAssignableFrom(dependency.getClass())) continue;
                    field.set(target, dependency);
                }
            }
        }
    }

    public static <T> T getValueOf(Object target, String fieldName) throws NoSuchFieldException {
        Field field = TestReflectionUtils.findFieldInHierarchy(target, fieldName);
        if (field == null) {
            throw new NoSuchFieldException(String.format("Field %s not found", fieldName));
        }
        field.setAccessible(true);
        try {
            return (T)field.get(target);
        }
        catch (IllegalAccessException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
    }

    public static void resetOf(Object target, String fieldName) throws NoSuchFieldException {
        TestReflectionUtils.setFieldValue(target, fieldName, null);
    }

    public static void setFieldValue(Object target, String fieldName, Object value) throws NoSuchFieldException {
        Field field = TestReflectionUtils.findFieldInHierarchy(target, fieldName);
        if (field == null) {
            throw new NoSuchFieldException(String.format("Field %s not found", fieldName));
        }
        field.setAccessible(true);
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
    }

    private static Field findFieldInHierarchy(Object target, String fieldName) throws NoSuchFieldException {
        if (target instanceof Class) {
            return ((Class)target).getDeclaredField(fieldName);
        }
        Class<?> targetClass = target.getClass();
        Field field = TestReflectionUtils.findField(targetClass, fieldName);
        while (field == null && !Object.class.equals(targetClass)) {
            targetClass = targetClass.getSuperclass();
            field = TestReflectionUtils.findField(targetClass, fieldName);
        }
        return field;
    }

    private static Field findField(Class<?> targetClass, String fieldName) {
        Field result = null;
        for (Field field : targetClass.getDeclaredFields()) {
            if (!fieldName.equals(field.getName())) continue;
            result = field;
        }
        return result;
    }
}

