/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util.resource.internal;

import be.atbash.util.ordered.Order;
import be.atbash.util.reflection.ClassUtils;
import be.atbash.util.resource.ResourceReader;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Order(value=-50L)
public class ClassPathResourceReader
implements ResourceReader {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathResourceReader.class);

    @Override
    public boolean canRead(String resourcePath, Object context) {
        return resourcePath.startsWith("classpath:");
    }

    @Override
    public boolean exists(String resourcePath, Object context) {
        boolean result = this.canRead(resourcePath, context);
        if (!result) {
            return false;
        }
        try {
            InputStream is = this.load(resourcePath, context);
            if (is == null) {
                result = false;
            } else {
                is.close();
            }
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    @Override
    public InputStream load(String resourcePath, Object context) throws IOException {
        InputStream result;
        if (!this.canRead(resourcePath, context)) {
            return null;
        }
        String cleanedPath = ClassPathResourceReader.stripPrefix(resourcePath);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Opening resource from class path [{}]", (Object)cleanedPath);
        }
        if ((result = ClassUtils.getResourceAsStream(cleanedPath)) == null && cleanedPath.startsWith("/")) {
            String newPath = cleanedPath.substring(1);
            result = this.load(newPath, context);
        }
        return result;
    }

    private static String stripPrefix(String resourcePath) {
        return resourcePath.substring(resourcePath.indexOf(58) + 1);
    }
}

