/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util.reflection;

import be.atbash.util.PublicAPI;
import be.atbash.util.reflection.InstantiationException;
import be.atbash.util.reflection.NoConstructorFoundException;
import be.atbash.util.reflection.UnknownClassException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicAPI
public final class ClassUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassUtils.class);
    private static final ClassLoaderAccessor THREAD_CL_ACCESSOR = new ExceptionIgnoringAccessor(){

        @Override
        protected ClassLoader doGetClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    private static final ClassLoaderAccessor CLASS_CL_ACCESSOR = new ExceptionIgnoringAccessor(){

        @Override
        protected ClassLoader doGetClassLoader() {
            return ClassUtils.class.getClassLoader();
        }
    };
    private static final ClassLoaderAccessor SYSTEM_CL_ACCESSOR = new ExceptionIgnoringAccessor(){

        @Override
        protected ClassLoader doGetClassLoader() {
            return ClassLoader.getSystemClassLoader();
        }
    };

    private ClassUtils() {
    }

    public static InputStream getResourceAsStream(String name) {
        InputStream is = THREAD_CL_ACCESSOR.getResourceStream(name);
        if (is == null) {
            if (log.isTraceEnabled()) {
                log.trace("Resource [" + name + "] was not found via the thread context ClassLoader.  Trying the current ClassLoader...");
            }
            is = CLASS_CL_ACCESSOR.getResourceStream(name);
        }
        if (is == null) {
            if (log.isTraceEnabled()) {
                log.trace("Resource [" + name + "] was not found via the current class loader.  Trying the system/application ClassLoader...");
            }
            is = SYSTEM_CL_ACCESSOR.getResourceStream(name);
        }
        if (is == null && log.isTraceEnabled()) {
            log.trace("Resource [" + name + "] was not found via the thread context, current, or system/application ClassLoaders.  All heuristics have been exhausted.  Returning null.");
        }
        return is;
    }

    public static Class forName(String fqcn) {
        Class clazz = THREAD_CL_ACCESSOR.loadClass(fqcn);
        if (clazz == null) {
            if (log.isTraceEnabled()) {
                log.trace("Unable to load class named [" + fqcn + "] from the thread context ClassLoader.  Trying the current ClassLoader...");
            }
            clazz = CLASS_CL_ACCESSOR.loadClass(fqcn);
        }
        if (clazz == null) {
            if (log.isTraceEnabled()) {
                log.trace("Unable to load class named [" + fqcn + "] from the current ClassLoader.  Trying the system/application ClassLoader...");
            }
            clazz = SYSTEM_CL_ACCESSOR.loadClass(fqcn);
        }
        if (clazz == null) {
            String msg = "Unable to load class named [" + fqcn + "] from the thread context, current, or system/application ClassLoaders.  All heuristics have been exhausted.  Class could not be found.";
            throw new UnknownClassException(msg);
        }
        return clazz;
    }

    public static boolean isAvailable(String fullyQualifiedClassName) {
        try {
            ClassUtils.forName(fullyQualifiedClassName);
            return true;
        }
        catch (UnknownClassException e) {
            return false;
        }
    }

    public static <T> T newInstance(String fqcn) {
        return ClassUtils.newInstance(ClassUtils.forName(fqcn));
    }

    public static <T> T newInstance(String fqcn, Object ... args) {
        return ClassUtils.newInstance(ClassUtils.forName(fqcn), args);
    }

    public static <T> T newInstance(Class clazz) {
        if (clazz == null) {
            String msg = "Class method parameter cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new InstantiationException("Unable to instantiate class [" + clazz.getName() + "]", e);
        }
    }

    public static <T> T newInstance(Class clazz, Object ... args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            argTypes[i] = args[i].getClass();
        }
        Constructor ctor = ClassUtils.getConstructor(clazz, argTypes);
        return ClassUtils.instantiate(ctor, args);
    }

    static Constructor getConstructor(Class clazz, Class ... argTypes) {
        return ClassUtils.matchConstructor(clazz, argTypes);
    }

    private static Constructor matchConstructor(Class clazz, Class[] argTypes) {
        List<Constructor> constructors = ClassUtils.matchAllConstructors(clazz, argTypes, true);
        if (constructors.isEmpty()) {
            constructors = ClassUtils.matchAllConstructors(clazz, argTypes, false);
        }
        if (constructors.size() != 1) {
            throw new NoConstructorFoundException(clazz, argTypes);
        }
        return constructors.get(0);
    }

    private static List<Constructor> matchAllConstructors(Class clazz, Class[] argTypes, boolean exactMatch) {
        ArrayList<Constructor> result = new ArrayList<Constructor>();
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != argTypes.length || !ClassUtils.matchParameterTypes(constructor.getParameterTypes(), argTypes, exactMatch)) continue;
            result.add(constructor);
        }
        return result;
    }

    private static boolean matchParameterTypes(Class[] parameterTypes, Class[] argTypes, boolean exactMatch) {
        boolean result = true;
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (argTypes[i] == null) continue;
            if (exactMatch) {
                if (parameterTypes[i].equals(argTypes[i])) continue;
                result = false;
                continue;
            }
            if (parameterTypes[i].isAssignableFrom(argTypes[i])) continue;
            result = false;
        }
        return result;
    }

    private static <T> T instantiate(Constructor ctor, Object ... args) {
        try {
            return ctor.newInstance(args);
        }
        catch (Exception e) {
            String msg = String.format("Unable to instantiate Permission instance with constructor [%s]", ctor);
            throw new InstantiationException(msg, e);
        }
    }

    private static abstract class ExceptionIgnoringAccessor
    implements ClassLoaderAccessor {
        private ExceptionIgnoringAccessor() {
        }

        @Override
        public Class loadClass(String fqcn) {
            Class<?> clazz;
            block3: {
                clazz = null;
                ClassLoader cl = this.getClassLoader();
                if (cl != null) {
                    try {
                        clazz = cl.loadClass(fqcn);
                    }
                    catch (ClassNotFoundException e) {
                        if (!log.isTraceEnabled()) break block3;
                        log.trace(String.format("Unable to load clazz named [%s] from class loader [%s]", fqcn, cl));
                    }
                }
            }
            return clazz;
        }

        @Override
        public InputStream getResourceStream(String name) {
            InputStream is = null;
            ClassLoader cl = this.getClassLoader();
            if (cl != null) {
                is = cl.getResourceAsStream(name);
            }
            return is;
        }

        final ClassLoader getClassLoader() {
            try {
                return this.doGetClassLoader();
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug("Unable to acquire ClassLoader.", (Throwable)e);
                }
                return null;
            }
        }

        protected abstract ClassLoader doGetClassLoader();
    }

    private static interface ClassLoaderAccessor {
        public Class loadClass(String var1);

        public InputStream getResourceStream(String var1);
    }
}

