/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util.codec;

import be.atbash.util.PublicAPI;
import be.atbash.util.codec.ByteSourceCreator;
import be.atbash.util.codec.DefaultByteSourceCreator;
import java.util.Iterator;
import java.util.ServiceLoader;

@PublicAPI
public interface ByteSource {
    public static final ByteSourceCreator creator = CreatorInitializer.defineCreator();

    public byte[] getBytes();

    public String toHex();

    public String toBase64();

    public String toBase32();

    public boolean isEmpty();

    public static final class CreatorInitializer {
        private CreatorInitializer() {
        }

        static ByteSourceCreator defineCreator() {
            Iterator<ByteSourceCreator> creatorIterator = ServiceLoader.load(ByteSourceCreator.class).iterator();
            if (creatorIterator.hasNext()) {
                return creatorIterator.next();
            }
            return new DefaultByteSourceCreator();
        }
    }
}

