/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util.version;

import be.atbash.util.PublicAPI;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicAPI
public class VersionReader {
    private Logger logger = LoggerFactory.getLogger(VersionReader.class);
    private String releaseVersion;
    private String buildTime;

    public VersionReader(String module) {
        this.readInfo(module);
    }

    private void readInfo(String module) {
        Properties properties = new Properties();
        try {
            URL manifestFile = this.findManifestFile(module);
            if (manifestFile != null) {
                InputStream resourceAsStream = manifestFile.openStream();
                properties.load(resourceAsStream);
                resourceAsStream.close();
            } else {
                this.logger.warn(String.format("Unable to find manifest file %s module", module));
            }
        }
        catch (IOException e) {
            this.logger.warn(String.format("Exception during loading of the %s MANIFEST.MF file : %s", module, e.getMessage()));
        }
        this.releaseVersion = properties.getProperty("Release-Version");
        this.buildTime = properties.getProperty("buildTime");
    }

    private URL findManifestFile(String module) throws IOException {
        URL result = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        Enumeration<URL> systemResources = classLoader.getResources("META-INF/MANIFEST.MF");
        while (systemResources.hasMoreElements() && result == null) {
            URL url = systemResources.nextElement();
            if (!url.toExternalForm().contains("/" + module)) continue;
            result = url;
        }
        return result;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getBuildTime() {
        return this.buildTime;
    }
}

