/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util.resource.internal.vfs;

import be.atbash.util.resource.internal.vfs.Vfs;
import be.atbash.util.resource.internal.vfs.ZipFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipDir
implements Vfs.Dir {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipDir.class);
    private java.util.zip.ZipFile jarFile;

    public ZipDir(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    @Override
    public String getPath() {
        return this.jarFile.getName();
    }

    @Override
    public Iterable<Vfs.File> getFiles() {
        ArrayList<Vfs.File> result = new ArrayList<Vfs.File>();
        Enumeration<? extends ZipEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            result.add(new ZipFile(this, entry));
        }
        return result;
    }

    @Override
    public void close() {
        try {
            this.jarFile.close();
        }
        catch (IOException e) {
            LOGGER.warn("Could not close JarFile", (Throwable)e);
        }
    }

    public String toString() {
        return this.jarFile.getName();
    }
}

