/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util.resource.internal.vfs;

import be.atbash.util.exception.AtbashUnexpectedException;
import be.atbash.util.resource.UrlType;
import be.atbash.util.resource.internal.ResourceWalkerException;
import be.atbash.util.resource.internal.vfs.JarInputDir;
import be.atbash.util.resource.internal.vfs.SystemDir;
import be.atbash.util.resource.internal.vfs.UrlTypeVFS;
import be.atbash.util.resource.internal.vfs.ZipDir;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Vfs {
    private static final Logger LOGGER = LoggerFactory.getLogger(Vfs.class);
    private static final String JAR_MARKER = ".jar!";
    private static List<UrlType> defaultUrlTypes = new ArrayList<UrlType>();

    public static void registerURLType(UrlType urlType) {
        defaultUrlTypes.add(0, urlType);
    }

    public static Dir fromURL(URL url) {
        for (UrlType type : defaultUrlTypes) {
            try {
                if (!type.matches(url)) continue;
                if (type.noScanningNeeded(url)) {
                    return null;
                }
                Dir dir = type.createDir(url);
                if (dir == null) continue;
                return dir;
            }
            catch (Exception e) {
                LOGGER.warn("could not create Dir using " + type + " from url " + url.toExternalForm() + ". skipping.", (Throwable)e);
            }
        }
        throw new ResourceWalkerException("could not create Vfs.Dir from url, no matching UrlType was found [" + url.toExternalForm() + "]\neither use fromURL(URL url, List<UrlType> urlTypes) or use the static setDefaultURLTypes(List<UrlType> urlTypes) or addDefaultURLTypes(UrlType urlType) with your specialized UrlType.");
    }

    public static java.io.File getFile(URL url) {
        java.io.File file;
        String path;
        try {
            path = url.toURI().getSchemeSpecificPart();
            file = new java.io.File(path);
            if (file.exists()) {
                return file;
            }
        }
        catch (URISyntaxException e) {
            throw new AtbashUnexpectedException(e);
        }
        try {
            path = URLDecoder.decode(url.getPath(), "UTF-8");
            if (path.contains(JAR_MARKER)) {
                path = path.substring(0, path.lastIndexOf(JAR_MARKER) + ".jar".length());
            }
            if ((file = new java.io.File(path)).exists()) {
                return file;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new AtbashUnexpectedException(e);
        }
        try {
            path = url.toExternalForm();
            if (path.startsWith("jar:")) {
                path = path.substring("jar:".length());
            }
            if (path.startsWith("wsjar:")) {
                path = path.substring("wsjar:".length());
            }
            if (path.startsWith("file:")) {
                path = path.substring("file:".length());
            }
            if (path.contains(JAR_MARKER)) {
                path = path.substring(0, path.indexOf(JAR_MARKER) + ".jar".length());
            }
            if ((file = new java.io.File(path)).exists()) {
                return file;
            }
            file = new java.io.File(path = path.replace("%20", " "));
            if (file.exists()) {
                return file;
            }
        }
        catch (Exception e) {
            throw new AtbashUnexpectedException(e);
        }
        return null;
    }

    private static boolean hasJarFileInPath(URL url) {
        return url.toExternalForm().matches(".*\\.jar(\\!.*|$)");
    }

    static {
        Collections.addAll(defaultUrlTypes, DefaultUrlTypes.values());
    }

    public static enum DefaultUrlTypes implements UrlType
    {
        jarFile{

            @Override
            public boolean matches(URL url) {
                return url.getProtocol().equals("file") && Vfs.hasJarFileInPath(url);
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                return new ZipDir(new JarFile(Vfs.getFile(url)));
            }

            @Override
            public boolean noScanningNeeded(URL url) {
                return false;
            }
        }
        ,
        jarUrl{

            @Override
            public boolean matches(URL url) {
                return "jar".equals(url.getProtocol()) || "zip".equals(url.getProtocol()) || "wsjar".equals(url.getProtocol());
            }

            @Override
            public boolean noScanningNeeded(URL url) {
                return false;
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                try {
                    URLConnection urlConnection = url.openConnection();
                    if (urlConnection instanceof JarURLConnection) {
                        return new ZipDir(((JarURLConnection)urlConnection).getJarFile());
                    }
                }
                catch (Exception urlConnection) {
                    // empty catch block
                }
                java.io.File file = Vfs.getFile(url);
                if (file != null) {
                    return new ZipDir(new JarFile(file));
                }
                return null;
            }
        }
        ,
        directory{

            @Override
            public boolean matches(URL url) {
                if (url.getProtocol().equals("file") && !Vfs.hasJarFileInPath(url)) {
                    java.io.File file = Vfs.getFile(url);
                    return file != null && file.isDirectory();
                }
                return false;
            }

            @Override
            public boolean noScanningNeeded(URL url) {
                return false;
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                return new SystemDir(Vfs.getFile(url));
            }
        }
        ,
        jboss_vfs{

            @Override
            public boolean matches(URL url) {
                return url.getProtocol().equals("vfs");
            }

            @Override
            public boolean noScanningNeeded(URL url) {
                return url.getPath().endsWith("META-INF/MANIFEST.MF");
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                Object content = url.openConnection().getContent();
                Class<?> virtualFile = Thread.currentThread().getContextClassLoader().loadClass("org.jboss.vfs.VirtualFile");
                java.io.File physicalFile = (java.io.File)virtualFile.getMethod("getPhysicalFile", new Class[0]).invoke(content, new Object[0]);
                String name = (String)virtualFile.getMethod("getName", new Class[0]).invoke(content, new Object[0]);
                java.io.File file = new java.io.File(physicalFile.getParentFile(), name);
                if (!file.exists() || !file.canRead()) {
                    file = physicalFile;
                }
                return file.isDirectory() ? new SystemDir(file) : new ZipDir(new JarFile(file));
            }
        }
        ,
        jboss_vfsfile{

            @Override
            public boolean matches(URL url) {
                return "vfszip".equals(url.getProtocol()) || "vfsfile".equals(url.getProtocol());
            }

            @Override
            public boolean noScanningNeeded(URL url) {
                return false;
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                return new UrlTypeVFS().createDir(url);
            }
        }
        ,
        bundle{

            @Override
            public boolean matches(URL url) {
                return url.getProtocol().startsWith("bundle");
            }

            @Override
            public boolean noScanningNeeded(URL url) {
                return false;
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                return Vfs.fromURL((URL)Thread.currentThread().getContextClassLoader().loadClass("org.eclipse.core.runtime.FileLocator").getMethod("resolve", URL.class).invoke(null, url));
            }
        }
        ,
        jarInputStream{

            @Override
            public boolean matches(URL url) {
                return url.toExternalForm().contains(".jar");
            }

            @Override
            public boolean noScanningNeeded(URL url) {
                return false;
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                return new JarInputDir(url);
            }
        };

    }

    public static interface File {
        public String getName();

        public String getRelativePath();
    }

    public static interface Dir {
        public String getPath();

        public Iterable<File> getFiles();

        public void close();
    }
}

