/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util.resource.internal.vfs;

import be.atbash.util.resource.internal.vfs.SystemFile;
import be.atbash.util.resource.internal.vfs.Vfs;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SystemDir
implements Vfs.Dir {
    private final File file;

    public SystemDir(File file) {
        if (!(file == null || file.isDirectory() && file.canRead())) {
            throw new RuntimeException("cannot use dir " + file);
        }
        this.file = file;
    }

    @Override
    public String getPath() {
        if (this.file == null) {
            return "/NO-SUCH-DIRECTORY/";
        }
        return this.file.getPath().replace("\\", "/");
    }

    @Override
    public Iterable<Vfs.File> getFiles() {
        if (this.file == null || !this.file.exists()) {
            return Collections.emptyList();
        }
        return new ArrayList<Vfs.File>(this.defineFiles(this.file));
    }

    private Collection<? extends Vfs.File> defineFiles(File parentFile) {
        ArrayList<? extends Vfs.File> result = new ArrayList<Vfs.File>();
        for (File item : SystemDir.listFiles(parentFile)) {
            if (item.isDirectory()) {
                result.addAll(this.defineFiles(item));
                continue;
            }
            result.add(new SystemFile(this, item));
        }
        return result;
    }

    private static List<File> listFiles(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            return Arrays.asList(files);
        }
        return new ArrayList<File>();
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.getPath();
    }
}

