/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util.resource.internal;

import be.atbash.util.ordered.Order;
import be.atbash.util.resource.ResourceReader;
import be.atbash.util.resource.internal.ClassPathResourceReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Order(value=-20L)
public class URLResourceReader
implements ResourceReader {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathResourceReader.class);
    static final String HTTP = "http:";
    static final String HTTPS = "https:";

    @Override
    public boolean canRead(String resourcePath, Object context) {
        String lowerCasePath = resourcePath.toLowerCase(Locale.ENGLISH);
        return resourcePath.startsWith("url:") || lowerCasePath.startsWith(HTTP) || lowerCasePath.startsWith(HTTPS);
    }

    @Override
    public boolean exists(String resourcePath, Object context) {
        boolean result = this.canRead(resourcePath, context);
        if (!result) {
            return false;
        }
        try {
            this.load(resourcePath, context);
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    @Override
    public InputStream load(String resourcePath, Object context) throws IOException {
        if (!this.canRead(resourcePath, context)) {
            return null;
        }
        String urlPath = URLResourceReader.stripPrefix(resourcePath);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Opening url {}", (Object)urlPath);
        }
        URL url = new URL(urlPath);
        return url.openStream();
    }

    private static String stripPrefix(String resourcePath) {
        String lowerCasePath = resourcePath.toLowerCase(Locale.ENGLISH);
        if (lowerCasePath.startsWith(HTTP) || lowerCasePath.startsWith(HTTPS)) {
            return resourcePath;
        }
        return resourcePath.substring(resourcePath.indexOf(58) + 1);
    }
}

