/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util.resource.internal;

import be.atbash.util.exception.AtbashUnexpectedException;
import be.atbash.util.resource.ResourceWalkerExecutorServiceProvider;
import be.atbash.util.resource.internal.ResourceWalkerException;
import be.atbash.util.resource.internal.Store;
import be.atbash.util.resource.internal.vfs.Vfs;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceWalker {
    private Logger logger = LoggerFactory.getLogger(ResourceWalker.class);
    private ExecutorService executorService;
    private Store store;

    public ResourceWalker(Store store) {
        this.store = store;
        Iterator<ResourceWalkerExecutorServiceProvider> providerIterator = ServiceLoader.load(ResourceWalkerExecutorServiceProvider.class).iterator();
        if (providerIterator.hasNext()) {
            this.executorService = providerIterator.next().getExecutorService();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void scan() {
        void var7_11;
        long time = System.currentTimeMillis();
        int scannedUrls = 0;
        ArrayList futures = new ArrayList();
        Collection<URL> urls = this.getClassPathURLs();
        for (final URL uRL : urls) {
            try {
                if (this.executorService != null) {
                    futures.add(this.executorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            ResourceWalker.this.logger.debug(String.format("[%s] scanning %s", Thread.currentThread(), uRL));
                            ResourceWalker.this.scan(uRL);
                        }
                    }));
                } else {
                    this.scan(uRL);
                }
                ++scannedUrls;
            }
            catch (ResourceWalkerException e) {
                this.logger.warn("could not create Vfs.Dir from url. Ignoring the exception and continuing", (Throwable)e);
            }
        }
        if (this.executorService != null) {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    throw new AtbashUnexpectedException(e);
                }
            }
        }
        time = System.currentTimeMillis() - time;
        int keys = this.store.keySet().size();
        boolean bl = false;
        for (String index : this.store.keySet()) {
            var7_11 += this.store.get(index).size();
        }
        this.logger.info(String.format("Reflections took %d ms to scan %d urls, producing %d keys and %d values %s", time, scannedUrls, keys, (int)var7_11, this.executorService != null ? "[using executorService]" : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(URL url) {
        Vfs.Dir dir = Vfs.fromURL(url);
        if (dir == null) {
            return;
        }
        try {
            for (Vfs.File file : dir.getFiles()) {
                String path = file.getRelativePath();
                if (path.endsWith(".class") || path.startsWith("META-INF/")) continue;
                this.store.put(path, url.toExternalForm());
            }
        }
        finally {
            dir.close();
        }
    }

    private ClassLoader contextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private ClassLoader staticClassLoader() {
        return ResourceWalker.class.getClassLoader();
    }

    private ClassLoader[] classLoaders() {
        ClassLoader[] classLoaderArray;
        ClassLoader contextClassLoader = this.contextClassLoader();
        ClassLoader staticClassLoader = this.staticClassLoader();
        if (contextClassLoader != null) {
            if (staticClassLoader != null && contextClassLoader != staticClassLoader) {
                ClassLoader[] classLoaderArray2 = new ClassLoader[2];
                classLoaderArray2[0] = contextClassLoader;
                classLoaderArray = classLoaderArray2;
                classLoaderArray2[1] = staticClassLoader;
            } else {
                ClassLoader[] classLoaderArray3 = new ClassLoader[1];
                classLoaderArray = classLoaderArray3;
                classLoaderArray3[0] = contextClassLoader;
            }
        } else {
            classLoaderArray = new ClassLoader[]{};
        }
        return classLoaderArray;
    }

    private Collection<URL> getClassPathURLs() {
        ClassLoader[] loaders;
        ArrayList<URL> result = new ArrayList<URL>();
        for (ClassLoader classLoader : loaders = this.classLoaders()) {
            try {
                Enumeration<URL> urls = classLoader.getResources("");
                this.addFoundURLs(result, urls);
                urls = classLoader.getResources("META-INF/MANIFEST.MF");
                this.addFoundURLs(result, urls);
            }
            catch (IOException e) {
                this.logger.error("error getting resources  ", (Throwable)e);
            }
        }
        return ResourceWalker.distinctUrls(result);
    }

    private void addFoundURLs(List<URL> result, Enumeration<URL> urls) {
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            result.add(url);
        }
    }

    private static Collection<URL> distinctUrls(Collection<URL> urls) {
        LinkedHashMap<String, URL> distinct = new LinkedHashMap<String, URL>(urls.size());
        for (URL url : urls) {
            distinct.put(url.toExternalForm(), url);
        }
        return distinct.values();
    }
}

