/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util.resource.internal;

import be.atbash.util.ordered.Order;
import be.atbash.util.resource.ResourceReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Order(value=0x7FFFFFFFFFFFFFFFL)
public class FileResourceReader
implements ResourceReader {
    private static final Logger LOG = LoggerFactory.getLogger(FileResourceReader.class);

    @Override
    public boolean canRead(String resourcePath, Object context) {
        String lowerCasePath = resourcePath.toLowerCase(Locale.ENGLISH);
        return !resourcePath.startsWith("classpath:") && !resourcePath.startsWith("url:") && !lowerCasePath.startsWith("http:") && !lowerCasePath.startsWith("https:");
    }

    @Override
    public boolean exists(String resourcePath, Object context) {
        String path = FileResourceReader.stripPrefix(resourcePath);
        File file = new File(path);
        return file.exists() && file.canRead();
    }

    @Override
    public InputStream load(String resourcePath, Object context) throws IOException {
        String path = FileResourceReader.stripPrefix(resourcePath);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Opening file [%s] ...", path));
        }
        return new FileInputStream(path);
    }

    private static String stripPrefix(String resourcePath) {
        String lowerCasePath = resourcePath.toLowerCase(Locale.ENGLISH);
        if (lowerCasePath.startsWith("file:")) {
            return resourcePath;
        }
        return resourcePath.substring(resourcePath.indexOf(58) + 1);
    }
}

