/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util.codec;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Base32Codec {
    private char[] DIGITS;
    private int MASK;
    private int SHIFT;
    private Map<Character, Integer> CHAR_MAP;
    private static final String SEPARATOR = "-";
    private static final Base32Codec INSTANCE = new Base32Codec("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567");

    private Base32Codec(String alphabet) {
        this.DIGITS = alphabet.toCharArray();
        this.MASK = this.DIGITS.length - 1;
        this.SHIFT = Integer.numberOfTrailingZeros(this.DIGITS.length);
        this.CHAR_MAP = new HashMap<Character, Integer>();
        for (int i = 0; i < this.DIGITS.length; ++i) {
            this.CHAR_MAP.put(Character.valueOf(this.DIGITS[i]), i);
        }
    }

    public static byte[] decode(String encoded) {
        return Base32Codec.getInstance().decodeInternal(encoded);
    }

    protected byte[] decodeInternal(String encoded) {
        encoded = encoded.trim().replaceAll(SEPARATOR, "").replaceAll(" ", "");
        encoded = encoded.replaceFirst("[=]*$", "");
        if ((encoded = encoded.toUpperCase(Locale.US)).length() == 0) {
            return new byte[0];
        }
        int encodedLength = encoded.length();
        int outLength = encodedLength * this.SHIFT / 8;
        byte[] result = new byte[outLength];
        int buffer = 0;
        int next = 0;
        int bitsLeft = 0;
        for (char c : encoded.toCharArray()) {
            if (!this.CHAR_MAP.containsKey(Character.valueOf(c))) {
                throw new IllegalArgumentException("Illegal character: " + c);
            }
            buffer <<= this.SHIFT;
            buffer |= this.CHAR_MAP.get(Character.valueOf(c)) & this.MASK;
            if ((bitsLeft += this.SHIFT) < 8) continue;
            result[next++] = (byte)(buffer >> bitsLeft - 8);
            bitsLeft -= 8;
        }
        return result;
    }

    public static String encodeToString(byte[] data) {
        return Base32Codec.getInstance().encodeInternal(data);
    }

    protected String encodeInternal(byte[] data) {
        if (data.length == 0) {
            return "";
        }
        if (data.length >= 0x10000000) {
            throw new IllegalArgumentException();
        }
        int outputLength = (data.length * 8 + this.SHIFT - 1) / this.SHIFT;
        StringBuilder result = new StringBuilder(outputLength);
        int buffer = data[0];
        int next = 1;
        for (int bitsLeft = 8; bitsLeft > 0 || next < data.length; bitsLeft -= this.SHIFT) {
            if (bitsLeft < this.SHIFT) {
                if (next < data.length) {
                    buffer <<= 8;
                    buffer |= data[next++] & 0xFF;
                    bitsLeft += 8;
                } else {
                    int pad = this.SHIFT - bitsLeft;
                    buffer <<= pad;
                    bitsLeft += pad;
                }
            }
            int index = this.MASK & buffer >> bitsLeft - this.SHIFT;
            result.append(this.DIGITS[index]);
        }
        return result.toString();
    }

    private static Base32Codec getInstance() {
        return INSTANCE;
    }
}

