/*
 * Copyright 2014-2018 Rudy De Busscher (https://www.atbash.be)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package be.atbash.util.exception;

import be.atbash.util.PublicAPI;
import be.atbash.util.StringUtils;

/**
 * This is some kind of Developer exception when (s)he has done something wrong.
 */
@PublicAPI
public class AtbashIllegalActionException extends AtbashException {

    /**
     * Constructs the Exception with the message
     *
     * @param message
     */
    public AtbashIllegalActionException(String message) {
        super(message);
        if (StringUtils.isEmpty(message)) {
            throw new AtbashIllegalActionException("An AtbashIllegalActionException always requires a reason message");
        }
    }
}
